/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api.request;

import com.emc.atmos.api.Acl;
import com.emc.atmos.api.ObjectId;
import com.emc.atmos.api.ObjectPath;
import com.emc.atmos.api.RestUtil;
import com.emc.atmos.api.bean.AccessTokenPolicy;
import com.emc.atmos.api.request.ContentRequest;
import com.emc.atmos.api.request.ObjectRequest;
import com.emc.util.HttpUtil;
import java.util.List;
import java.util.Map;

public class CreateAccessTokenRequest
extends ObjectRequest<CreateAccessTokenRequest>
implements ContentRequest {
    protected Acl acl;
    protected AccessTokenPolicy policy;

    @Override
    public String getServiceRelativePath() {
        return "accesstokens";
    }

    @Override
    public String getMethod() {
        return "POST";
    }

    @Override
    public Map<String, List<Object>> generateHeaders() {
        Map<String, List<Object>> headers = super.generateHeaders();
        if (this.identifier != null) {
            if (this.identifier instanceof ObjectId) {
                RestUtil.addValue(headers, "x-emc-objectid", this.identifier);
            } else if (this.identifier instanceof ObjectPath) {
                RestUtil.addValue(headers, "x-emc-utf8", "true");
                RestUtil.addValue(headers, "x-emc-path", HttpUtil.encodeUtf8(this.identifier.toString()));
            } else {
                throw new UnsupportedOperationException("Only object ID and path are currently supported in access tokens");
            }
        }
        if (this.acl != null) {
            headers.put("x-emc-useracl", this.acl.getUserAclHeader());
            headers.put("x-emc-groupacl", this.acl.getGroupAclHeader());
        }
        return headers;
    }

    @Override
    protected CreateAccessTokenRequest me() {
        return this;
    }

    @Override
    public String getContentType() {
        return "application/xml";
    }

    @Override
    public Object getContent() {
        return this.policy;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    public CreateAccessTokenRequest acl(Acl acl) {
        this.acl = acl;
        return this;
    }

    public CreateAccessTokenRequest policy(AccessTokenPolicy policy) {
        this.policy = policy;
        return this;
    }

    public Acl getAcl() {
        return this.acl;
    }

    public AccessTokenPolicy getPolicy() {
        return this.policy;
    }

    public void setAcl(Acl acl) {
        this.acl = acl;
    }

    public void setPolicy(AccessTokenPolicy policy) {
        this.policy = policy;
    }
}

