/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api.request;

import com.emc.atmos.api.Range;
import com.emc.atmos.api.RestUtil;
import com.emc.atmos.api.request.ObjectRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ReadObjectRequest
extends ObjectRequest<ReadObjectRequest> {
    protected List<Range> ranges;

    @Override
    public String getServiceRelativePath() {
        return this.identifier.getRelativeResourcePath();
    }

    @Override
    public String getMethod() {
        return "GET";
    }

    @Override
    public Map<String, List<Object>> generateHeaders() {
        Map<String, List<Object>> headers = super.generateHeaders();
        RestUtil.addValue(headers, "x-emc-utf8", "true");
        if (this.ranges != null && !this.ranges.isEmpty()) {
            RestUtil.addValue(headers, "Range", "bytes=" + RestUtil.join(this.ranges, ","));
        }
        return headers;
    }

    @Override
    protected ReadObjectRequest me() {
        return this;
    }

    public ReadObjectRequest ranges(Range ... range) {
        if (range == null || range.length == 1 && range[0] == null) {
            range = new Range[]{};
        }
        this.setRanges(Arrays.asList(range));
        return this;
    }

    public List<Range> getRanges() {
        return this.ranges;
    }

    public void setRanges(List<Range> ranges) {
        this.ranges = ranges;
    }
}

