/*
 * Decompiled with CFR 0.152.
 */
package com.emc.esu.api.rest;

import com.emc.esu.api.Acl;
import com.emc.esu.api.BufferSegment;
import com.emc.esu.api.Checksum;
import com.emc.esu.api.DirectoryEntry;
import com.emc.esu.api.EsuApi;
import com.emc.esu.api.EsuException;
import com.emc.esu.api.Extent;
import com.emc.esu.api.Grant;
import com.emc.esu.api.Grantee;
import com.emc.esu.api.Identifier;
import com.emc.esu.api.ListOptions;
import com.emc.esu.api.Metadata;
import com.emc.esu.api.MetadataList;
import com.emc.esu.api.MetadataTag;
import com.emc.esu.api.MetadataTags;
import com.emc.esu.api.ObjectId;
import com.emc.esu.api.ObjectPath;
import com.emc.esu.api.ObjectResult;
import com.emc.esu.api.ServiceInformation;
import com.emc.esu.api.Version;
import com.emc.util.HttpUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public abstract class AbstractEsuRestApi
implements EsuApi {
    private static final DateFormat HEADER_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.ENGLISH);
    private static final String ISO8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final Pattern OBJECTID_EXTRACTOR = Pattern.compile("/\\w+/objects/([0-9a-f]{44,})");
    private static final Logger l4j = Logger.getLogger(AbstractEsuRestApi.class);
    protected String host;
    protected int port;
    protected String uid;
    protected byte[] secret;
    protected String context = "/rest";
    protected String proto;
    protected boolean unicodeEnabled = false;
    protected boolean readChecksum;
    private long serverOffset;

    public AbstractEsuRestApi(String host, int port, String uid, String sharedSecret) {
        try {
            this.secret = Base64.decodeBase64((byte[])sharedSecret.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new EsuException("Could not decode shared secret", e);
        }
        this.host = host;
        this.uid = uid;
        this.port = port;
        this.proto = port == 443 ? "https" : "http";
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getProtocol() {
        return this.proto;
    }

    public void setProtocol(String proto) {
        this.proto = proto;
    }

    @Override
    public ObjectId createObject(Acl acl, MetadataList metadata, byte[] data, String mimeType) {
        return this.createObjectFromSegment(acl, metadata, data == null ? null : new BufferSegment(data), mimeType, null);
    }

    @Override
    public ObjectId createObject(Acl acl, MetadataList metadata, byte[] data, String mimeType, Checksum checksum) {
        return this.createObjectFromSegment(acl, metadata, data == null ? null : new BufferSegment(data), mimeType, checksum);
    }

    @Override
    public ObjectId createObjectFromSegment(Acl acl, MetadataList metadata, BufferSegment data, String mimeType) {
        return this.createObjectFromSegment(acl, metadata, data, mimeType, null);
    }

    @Override
    public ObjectId createObjectOnPath(ObjectPath path, Acl acl, MetadataList metadata, byte[] data, String mimeType) {
        return this.createObjectFromSegmentOnPath(path, acl, metadata, data == null ? null : new BufferSegment(data), mimeType, null);
    }

    @Override
    public ObjectId createObjectOnPath(ObjectPath path, Acl acl, MetadataList metadata, byte[] data, String mimeType, Checksum checksum) {
        return this.createObjectFromSegmentOnPath(path, acl, metadata, data == null ? null : new BufferSegment(data), mimeType, checksum);
    }

    @Override
    public ObjectId createObjectFromSegmentOnPath(ObjectPath path, Acl acl, MetadataList metadata, BufferSegment data, String mimeType) {
        return this.createObjectFromSegmentOnPath(path, acl, metadata, data, mimeType, null);
    }

    @Override
    public void updateObject(Identifier id, Acl acl, MetadataList metadata, Extent extent, byte[] data, String mimeType) {
        this.updateObjectFromSegment(id, acl, metadata, extent, data == null ? null : new BufferSegment(data), mimeType, null);
    }

    @Override
    public void updateObject(Identifier id, Acl acl, MetadataList metadata, Extent extent, byte[] data, String mimeType, Checksum checksum) {
        this.updateObjectFromSegment(id, acl, metadata, extent, data == null ? null : new BufferSegment(data), mimeType, checksum);
    }

    @Override
    public void updateObjectFromSegment(Identifier id, Acl acl, MetadataList metadata, Extent extent, BufferSegment data, String mimeType) {
        this.updateObjectFromSegment(id, acl, metadata, extent, data, mimeType, null);
    }

    @Override
    public byte[] readObject(Identifier id, Extent extent, byte[] buffer) {
        return this.readObject(id, extent, buffer, null);
    }

    @Override
    public List<Identifier> listObjects(MetadataTag tag) {
        return this.filterIdList(this.listObjects(tag.getName(), null));
    }

    @Override
    public List<ObjectResult> listObjects(MetadataTag tag, ListOptions options) {
        return this.listObjects(tag.getName(), options);
    }

    @Override
    public List<Identifier> listObjects(String tag) {
        return this.filterIdList(this.listObjects(tag, null));
    }

    @Override
    public List<ObjectResult> listObjectsWithMetadata(MetadataTag tag) {
        return this.listObjectsWithMetadata(tag.getName());
    }

    @Override
    public List<ObjectResult> listObjectsWithMetadata(String tag) {
        ListOptions options = new ListOptions();
        options.setIncludeMetadata(true);
        return this.listObjects(tag, options);
    }

    @Override
    public List<DirectoryEntry> listDirectory(ObjectPath path) {
        return this.listDirectory(path, null);
    }

    public String sign(String input) throws NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, UnsupportedEncodingException {
        l4j.debug((Object)("Hashing: \n" + input.toString()));
        String hashOut = this.sign(input.getBytes("UTF-8"));
        l4j.debug((Object)("Hash: " + hashOut));
        return hashOut;
    }

    public String sign(byte[] input) throws UnsupportedEncodingException, InvalidKeyException, NoSuchAlgorithmException {
        Mac mac = Mac.getInstance("HmacSHA1");
        SecretKeySpec key = new SecretKeySpec(this.secret, "HmacSHA1");
        mac.init(key);
        byte[] hashData = mac.doFinal(input);
        return new String(Base64.encodeBase64((byte[])hashData), "UTF-8");
    }

    @Override
    public URL getShareableUrl(Identifier id, Date expiration, String disposition) {
        try {
            String resource = this.getResourcePath(this.context, id);
            StringBuffer sb = new StringBuffer();
            sb.append("GET\n");
            sb.append(resource.toLowerCase() + "\n");
            sb.append(this.uid + "\n");
            sb.append("" + expiration.getTime() / 1000L);
            if (disposition != null) {
                sb.append("\n" + disposition);
            }
            String signature = this.sign(sb.toString());
            String query = "uid=" + this.encodeUtf8(this.uid) + "&expires=" + expiration.getTime() / 1000L + "&signature=" + this.encodeUtf8(signature);
            if (disposition != null) {
                disposition = this.encodeUtf8(disposition);
                query = query + "&disposition=" + disposition;
            }
            URL u = this.buildUrl(resource, null);
            u = new URL(u.toString() + "?" + query);
            l4j.debug((Object)("URL: " + u));
            return u;
        }
        catch (UnsupportedEncodingException e) {
            throw new EsuException("Unsupported encoding", e);
        }
        catch (InvalidKeyException e) {
            throw new EsuException("Invalid secret key", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EsuException("Missing signature algorithm", e);
        }
        catch (IllegalStateException e) {
            throw new EsuException("Error signing request", e);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL format", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public URL getShareableUrl(Identifier id, Date expiration) {
        return this.getShareableUrl(id, expiration, null);
    }

    protected String getResourcePath(String ctx, Identifier id) {
        if (id instanceof ObjectId) {
            return ctx + "/objects/" + id;
        }
        return ctx + "/namespace" + id;
    }

    protected URL buildUrl(String resource, String query) throws URISyntaxException, MalformedURLException {
        int uriport = 0;
        uriport = "http".equals(this.proto) && this.port == 80 ? -1 : ("https".equals(this.proto) && this.port == 443 ? -1 : this.port);
        URI uri = new URI(this.proto, null, this.host, uriport, resource, query, null);
        l4j.debug((Object)("URI: " + uri));
        URL u = new URL(uri.toASCIIString());
        l4j.debug((Object)("URL: " + u));
        return u;
    }

    protected void silentClose(OutputStream out) {
        if (out == null) {
            return;
        }
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void readMetadata(MetadataList meta, String header, boolean listable) throws UnsupportedEncodingException {
        if (header == null) {
            return;
        }
        String[] attrs = header.split(",(?=[^,]+=)");
        for (int i = 0; i < attrs.length; ++i) {
            String[] nvpair = attrs[i].split("=", 2);
            String name = nvpair[0];
            String value = nvpair.length > 1 ? nvpair[1] : null;
            name = name.trim();
            if (this.unicodeEnabled) {
                name = this.decodeUtf8(name);
                value = this.decodeUtf8(value);
            }
            Metadata m = new Metadata(name, value, listable);
            l4j.debug((Object)("Meta: " + m));
            meta.addMetadata(m);
        }
    }

    protected void processTags(MetadataTags tags, Map<String, String> headers) throws UnsupportedEncodingException {
        StringBuffer taglist = new StringBuffer();
        l4j.debug((Object)("Processing " + tags.count() + " metadata tag entries"));
        if (this.unicodeEnabled) {
            headers.put("x-emc-utf8", "true");
        }
        for (MetadataTag tag : tags) {
            if (taglist.length() > 0) {
                taglist.append(",");
            }
            taglist.append(this.unicodeEnabled ? this.encodeUtf8(tag.getName()) : tag.getName());
        }
        if (taglist.length() > 0) {
            headers.put("x-emc-tags", taglist.toString());
        }
    }

    protected void readAcl(Acl acl, String header, Grantee.GRANT_TYPE type) {
        l4j.debug((Object)("readAcl: " + header));
        String[] grants = header.split(",");
        for (int i = 0; i < grants.length; ++i) {
            String[] nvpair = grants[i].split("=", 2);
            String grantee = nvpair[0];
            String permission = nvpair[1];
            grantee = grantee.trim();
            if ("FULL".equals(permission)) {
                permission = "FULL_CONTROL";
            }
            l4j.debug((Object)("grant: " + grantee + "." + permission + " (" + (Object)((Object)type) + ")"));
            Grantee ge = new Grantee(grantee, type);
            Grant gr = new Grant(ge, permission);
            l4j.debug((Object)("Grant: " + gr));
            acl.addGrant(gr);
        }
    }

    protected List<ObjectId> parseObjectList(byte[] response) {
        ArrayList<ObjectId> objs = new ArrayList<ObjectId>();
        SAXBuilder sb = new SAXBuilder();
        try {
            Document d = sb.build((InputStream)new ByteArrayInputStream(response));
            Namespace esuNs = Namespace.getNamespace((String)"http://www.emc.com/cos/");
            List children = d.getRootElement().getChildren("ObjectID", esuNs);
            l4j.debug((Object)("Found " + children.size() + " objects"));
            for (Object o : children) {
                if (o instanceof Element) {
                    ObjectId oid = new ObjectId(((Element)o).getText());
                    l4j.debug((Object)oid.toString());
                    objs.add(oid);
                    continue;
                }
                l4j.debug((Object)(o + " is not an Element!"));
            }
        }
        catch (JDOMException e) {
            throw new EsuException("Error parsing response", e);
        }
        catch (IOException e) {
            throw new EsuException("Error reading response", e);
        }
        return objs;
    }

    protected List<Identifier> parseVersionList(byte[] response) {
        ArrayList<Identifier> objs = new ArrayList<Identifier>();
        SAXBuilder sb = new SAXBuilder();
        try {
            Document d = sb.build((InputStream)new ByteArrayInputStream(response));
            Namespace esuNs = Namespace.getNamespace((String)"http://www.emc.com/cos/");
            List children = d.getRootElement().getChildren("Ver", esuNs);
            l4j.debug((Object)("Found " + children.size() + " objects"));
            for (Object o : children) {
                if (o instanceof Element) {
                    Element objectIdElement = (Element)((Element)o).getChildren("OID", esuNs).get(0);
                    ObjectId oid = new ObjectId(objectIdElement.getText());
                    l4j.debug((Object)oid.toString());
                    objs.add(oid);
                    continue;
                }
                l4j.debug((Object)(o + " is not an Element!"));
            }
        }
        catch (JDOMException e) {
            throw new EsuException("Error parsing response", e);
        }
        catch (IOException e) {
            throw new EsuException("Error reading response", e);
        }
        return objs;
    }

    protected List<Version> parseVersionListLong(byte[] response) {
        ArrayList<Version> objs = new ArrayList<Version>();
        SimpleDateFormat itimeParser = new SimpleDateFormat(ISO8601_FORMAT);
        itimeParser.setTimeZone(TimeZone.getTimeZone("UTC"));
        SAXBuilder sb = new SAXBuilder();
        try {
            Document d = sb.build((InputStream)new ByteArrayInputStream(response));
            Namespace esuNs = Namespace.getNamespace((String)"http://www.emc.com/cos/");
            List children = d.getRootElement().getChildren("Ver", esuNs);
            l4j.debug((Object)("Found " + children.size() + " objects"));
            for (Object o : children) {
                if (o instanceof Element) {
                    Element e = (Element)o;
                    ObjectId id = new ObjectId(e.getChildText("OID", esuNs));
                    int versionNumber = Integer.parseInt(e.getChildText("VerNum", esuNs));
                    String sitime = e.getChildText("itime", esuNs);
                    Date itime = null;
                    try {
                        itime = itimeParser.parse(sitime);
                    }
                    catch (ParseException e1) {
                        throw new EsuException("Could not parse itime: " + sitime, e1);
                    }
                    objs.add(new Version(id, versionNumber, itime));
                    continue;
                }
                l4j.debug((Object)(o + " is not an Element!"));
            }
        }
        catch (JDOMException e) {
            throw new EsuException("Error parsing response", e);
        }
        catch (IOException e) {
            throw new EsuException("Error reading response", e);
        }
        return objs;
    }

    protected List<ObjectResult> parseObjectListWithMetadata(byte[] response) {
        ArrayList<ObjectResult> objs = new ArrayList<ObjectResult>();
        SAXBuilder sb = new SAXBuilder();
        try {
            Document d = sb.build((InputStream)new ByteArrayInputStream(response));
            Namespace esuNs = Namespace.getNamespace((String)"http://www.emc.com/cos/");
            List children = d.getRootElement().getChildren("Object", esuNs);
            l4j.debug((Object)("Found " + children.size() + " objects"));
            for (Object o : children) {
                if (o instanceof Element) {
                    String mValue;
                    String mName;
                    Element e = (Element)o;
                    ObjectResult obj = new ObjectResult();
                    Element objectIdElement = e.getChild("ObjectID", esuNs);
                    ObjectId oid = new ObjectId(objectIdElement.getText());
                    obj.setId(oid);
                    Element sMeta = e.getChild("SystemMetadataList", esuNs);
                    Element uMeta = e.getChild("UserMetadataList", esuNs);
                    obj.setMetadata(new MetadataList());
                    if (sMeta != null) {
                        for (Element metaElement : sMeta.getChildren("Metadata", esuNs)) {
                            mName = metaElement.getChildText("Name", esuNs);
                            mValue = metaElement.getChildText("Value", esuNs);
                            obj.getMetadata().addMetadata(new Metadata(mName, mValue, false));
                        }
                    }
                    if (uMeta != null) {
                        for (Element metaElement : uMeta.getChildren("Metadata", esuNs)) {
                            mName = metaElement.getChildText("Name", esuNs);
                            mValue = metaElement.getChildText("Value", esuNs);
                            String mListable = metaElement.getChildText("Listable", esuNs);
                            obj.getMetadata().addMetadata(new Metadata(mName, mValue, "true".equals(mListable)));
                        }
                    }
                    objs.add(obj);
                    continue;
                }
                l4j.debug((Object)(o + " is not an Element!"));
            }
        }
        catch (JDOMException e) {
            throw new EsuException("Error parsing response", e);
        }
        catch (IOException e) {
            throw new EsuException("Error reading response", e);
        }
        return objs;
    }

    protected List<DirectoryEntry> parseDirectoryListing(byte[] data, ObjectPath basePath) {
        ArrayList<DirectoryEntry> objs = new ArrayList<DirectoryEntry>();
        SAXBuilder sb = new SAXBuilder();
        try {
            Document d = sb.build((InputStream)new ByteArrayInputStream(data));
            Namespace esuNs = Namespace.getNamespace((String)"http://www.emc.com/cos/");
            List children = d.getRootElement().getChild("DirectoryList", esuNs).getChildren("DirectoryEntry", esuNs);
            l4j.debug((Object)("Found " + children.size() + " objects"));
            for (Object o : children) {
                if (o instanceof Element) {
                    String mValue;
                    String mName;
                    DirectoryEntry de = new DirectoryEntry();
                    de.setId(new ObjectId(((Element)o).getChildText("ObjectID", esuNs)));
                    String name = ((Element)o).getChildText("Filename", esuNs);
                    String type = ((Element)o).getChildText("FileType", esuNs);
                    name = basePath.toString() + name;
                    if ("directory".equals(type)) {
                        name = name + "/";
                    }
                    de.setPath(new ObjectPath(name));
                    de.setType(type);
                    Element sMeta = ((Element)o).getChild("SystemMetadataList", esuNs);
                    Element uMeta = ((Element)o).getChild("UserMetadataList", esuNs);
                    if (sMeta != null) {
                        de.setSystemMetadata(new MetadataList());
                        for (Element metaElement : sMeta.getChildren("Metadata", esuNs)) {
                            mName = metaElement.getChildText("Name", esuNs);
                            mValue = metaElement.getChildText("Value", esuNs);
                            de.getSystemMetadata().addMetadata(new Metadata(mName, mValue, false));
                        }
                    }
                    if (uMeta != null) {
                        de.setUserMetadata(new MetadataList());
                        for (Element metaElement : uMeta.getChildren("Metadata", esuNs)) {
                            mName = metaElement.getChildText("Name", esuNs);
                            mValue = metaElement.getChildText("Value", esuNs);
                            String mListable = metaElement.getChildText("Listable", esuNs);
                            de.getUserMetadata().addMetadata(new Metadata(mName, mValue, "true".equals(mListable)));
                        }
                    }
                    objs.add(de);
                    continue;
                }
                l4j.debug((Object)(o + " is not an Element!"));
            }
        }
        catch (JDOMException e) {
            throw new EsuException("Error parsing response", e);
        }
        catch (IOException e) {
            throw new EsuException("Error reading response", e);
        }
        return objs;
    }

    protected void readTags(MetadataTags tags, String header, boolean listable) throws UnsupportedEncodingException {
        if (header == null) {
            return;
        }
        String[] attrs = header.split(",");
        for (int i = 0; i < attrs.length; ++i) {
            String attr = attrs[i].trim();
            tags.addTag(new MetadataTag(this.unicodeEnabled ? this.decodeUtf8(attr) : attr, listable));
        }
    }

    protected void processMetadata(MetadataList metadata, Map<String, String> headers) throws UnsupportedEncodingException {
        StringBuffer listable = new StringBuffer();
        StringBuffer nonListable = new StringBuffer();
        if (this.unicodeEnabled) {
            headers.put("x-emc-utf8", "true");
        }
        l4j.debug((Object)("Processing " + metadata.count() + " metadata entries"));
        for (Metadata meta : metadata) {
            if (meta.isListable()) {
                if (listable.length() > 0) {
                    listable.append(", ");
                }
                listable.append(this.formatTag(meta));
                continue;
            }
            if (nonListable.length() > 0) {
                nonListable.append(", ");
            }
            nonListable.append(this.formatTag(meta));
        }
        if (listable.length() > 0) {
            headers.put("x-emc-listable-meta", listable.toString());
        }
        if (nonListable.length() > 0) {
            headers.put("x-emc-meta", nonListable.toString());
        }
    }

    protected String formatTag(Metadata meta) throws UnsupportedEncodingException {
        if (this.unicodeEnabled) {
            String name = this.encodeUtf8(meta.getName());
            if (meta.getValue() == null) {
                return name + "=";
            }
            String value = this.encodeUtf8(meta.getValue());
            return name + "=" + value;
        }
        if (meta.getValue() == null) {
            return meta.getName() + "=";
        }
        String fixed = meta.getValue().replace("\n", "");
        fixed = fixed.replace(",", "");
        return meta.getName() + "=" + fixed;
    }

    protected String encodeUtf8(String value) throws UnsupportedEncodingException {
        return HttpUtil.encodeUtf8(value);
    }

    protected String decodeUtf8(String value) throws UnsupportedEncodingException {
        return HttpUtil.decodeUtf8(value);
    }

    protected void processAcl(Acl acl, Map<String, String> headers) {
        StringBuffer userGrants = new StringBuffer();
        StringBuffer groupGrants = new StringBuffer();
        for (Grant grant : acl) {
            if (grant.getGrantee().getType() == Grantee.GRANT_TYPE.USER) {
                if (userGrants.length() > 0) {
                    userGrants.append(",");
                }
                userGrants.append(grant.toString());
                continue;
            }
            if (groupGrants.length() > 0) {
                groupGrants.append(",");
            }
            groupGrants.append(grant.toString());
        }
        headers.put("x-emc-useracl", userGrants.toString());
        headers.put("x-emc-groupacl", groupGrants.toString());
    }

    protected String normalizeSpace(String str) {
        int length = str.length();
        while ((str = str.replace("  ", " ")).length() != length) {
            length = str.length();
        }
        while (str.endsWith(" ")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDateHeader() {
        TimeZone tz = TimeZone.getTimeZone("GMT");
        l4j.debug((Object)("TZ: " + tz));
        DateFormat dateFormat = HEADER_FORMAT;
        synchronized (dateFormat) {
            HEADER_FORMAT.setTimeZone(tz);
            String dateHeader = HEADER_FORMAT.format(new Date(System.currentTimeMillis() - this.serverOffset));
            l4j.debug((Object)("Date: " + dateHeader));
            return dateHeader;
        }
    }

    protected ObjectId getObjectId(String location) {
        Matcher m = OBJECTID_EXTRACTOR.matcher(location);
        if (m.find()) {
            String vid = m.group(1);
            l4j.debug((Object)("vId: " + vid));
            return new ObjectId(vid);
        }
        throw new EsuException("Could not find ObjectId in " + location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readStream(InputStream in, int contentLength) throws IOException {
        try {
            if (contentLength != -1) {
                int read2;
                byte[] output = new byte[contentLength];
                for (int c = 0; c < contentLength; c += read2) {
                    read2 = in.read(output, c, contentLength - c);
                    if (read2 != -1) continue;
                    throw new EOFException("EOF reading response at position " + c + " size " + (contentLength - c));
                }
                byte[] read2 = output;
                return read2;
            }
            l4j.debug((Object)"Content length is unknown.  Buffering output.");
            byte[] buffer = new byte[4096];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int c = 0;
            while ((c = in.read(buffer)) != -1) {
                baos.write(buffer, 0, c);
            }
            baos.close();
            l4j.debug((Object)("Buffered " + baos.size() + " response bytes"));
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    protected ServiceInformation parseServiceInformation(byte[] response, Map<String, List<String>> map) {
        SAXBuilder sb = new SAXBuilder();
        try {
            Document d = sb.build((InputStream)new ByteArrayInputStream(response));
            ServiceInformation si = new ServiceInformation();
            Namespace esuNs = Namespace.getNamespace((String)"http://www.emc.com/cos/");
            Element ver = d.getRootElement().getChild("Version", esuNs);
            Element atmos = ver.getChild("Atmos", esuNs);
            si.setAtmosVersion(atmos.getTextNormalize());
            for (String key : map.keySet()) {
                if ("x-emc-support-utf8".equalsIgnoreCase(key)) {
                    for (String val : map.get(key)) {
                        if (!"true".equalsIgnoreCase(val)) continue;
                        si.setUnicodeMetadataSupported(true);
                    }
                }
                if (!"x-emc-features".equalsIgnoreCase(key)) continue;
                for (String val : map.get(key)) {
                    String[] features;
                    for (String feature : features = val.split(",")) {
                        si.addFeature(feature.trim());
                    }
                }
            }
            return si;
        }
        catch (JDOMException e) {
            throw new EsuException("Error parsing response", e);
        }
        catch (IOException e) {
            throw new EsuException("Error reading response", e);
        }
    }

    private List<Identifier> filterIdList(List<ObjectResult> list) {
        ArrayList<Identifier> result = new ArrayList<Identifier>(list.size());
        for (ObjectResult r : list) {
            result.add(r.getId());
        }
        return result;
    }

    protected String join(List<String> list, String delimiter) {
        boolean first = true;
        StringBuffer sb = new StringBuffer();
        for (String s : list) {
            if (first) {
                first = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public boolean isReadChecksum() {
        return this.readChecksum;
    }

    public void setReadChecksum(boolean readChecksum) {
        this.readChecksum = readChecksum;
    }

    @Override
    public boolean isUnicodeEnabled() {
        return this.unicodeEnabled;
    }

    @Override
    public void setUnicodeEnabled(boolean unicodeEnabled) {
        this.unicodeEnabled = unicodeEnabled;
    }

    public long getServerOffset() {
        return this.serverOffset;
    }

    public void setServerOffset(long serverOffset) {
        this.serverOffset = serverOffset;
    }

    public abstract long calculateServerOffset();

    @Override
    public ObjectId createObjectWithKey(String keyPool, String key, Acl acl, MetadataList metadata, byte[] data, long length, String mimeType) {
        return this.createObjectWithKeyFromSegment(keyPool, key, acl, metadata, new BufferSegment(data, 0, (int)length), mimeType);
    }

    @Override
    public ObjectId createObjectWithKey(String keyPool, String key, Acl acl, MetadataList metadata, byte[] data, long length, String mimeType, Checksum checksum) {
        return this.createObjectWithKeyFromSegment(keyPool, key, acl, metadata, new BufferSegment(data, 0, (int)length), mimeType, checksum);
    }

    @Override
    public ObjectId createObjectWithKeyFromSegment(String keyPool, String key, Acl acl, MetadataList metadata, BufferSegment data, String mimeType) {
        return this.createObjectWithKeyFromSegment(keyPool, key, acl, metadata, data, mimeType, null);
    }

    @Override
    public byte[] readObjectWithKey(String keyPool, String key, Extent extent, byte[] buffer) {
        return this.readObjectWithKey(keyPool, key, extent, buffer, null);
    }

    @Override
    public void updateObjectWithKey(String keyPool, String key, Acl acl, MetadataList metadata, Extent extent, byte[] data, String mimeType) {
        this.updateObjectWithKeyFromSegment(keyPool, key, acl, metadata, extent, new BufferSegment(data), mimeType);
    }

    @Override
    public void updateObjectWithKey(String keyPool, String key, Acl acl, MetadataList metadata, Extent extent, byte[] data, String mimeType, Checksum checksum) {
        this.updateObjectWithKeyFromSegment(keyPool, key, acl, metadata, extent, new BufferSegment(data), mimeType, checksum);
    }

    @Override
    public void updateObjectWithKeyFromSegment(String keyPool, String key, Acl acl, MetadataList metadata, Extent extent, BufferSegment data, String mimeType) {
        this.updateObjectWithKeyFromSegment(keyPool, key, acl, metadata, extent, data, mimeType, null);
    }
}

