/*
 * Decompiled with CFR 0.152.
 */
package com.emc.esu.sysmgmt;

import com.emc.esu.api.EsuException;
import com.emc.esu.sysmgmt.SysMgmtResponse;
import com.emc.esu.sysmgmt.SysMgmtUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class ListRmgResponse
extends SysMgmtResponse {
    private List<Rmg> rmgs;

    public ListRmgResponse(HttpURLConnection con) throws IOException, JDOMException {
        super(con);
        Document doc = SysMgmtUtils.parseResponseXml(con);
        Element root = doc.getRootElement();
        this.rmgs = new ArrayList<Rmg>();
        List rmgsXml = root.getChildren("rmg");
        for (Object o : rmgsXml) {
            if (!(o instanceof Element)) {
                throw new EsuException("Expected XML Element got " + o.getClass());
            }
            Element e = (Element)o;
            Rmg r = new Rmg();
            r.setName(e.getChildText("name"));
            r.setLocalTime(e.getChildText("localTime"));
            r.setNodesUp(Integer.parseInt(e.getChildText("nodesUp")));
            r.setNodesDown(Integer.parseInt(e.getChildText("nodesDown")));
            r.setAvgLoad1(Float.parseFloat(e.getChildText("avgLoad1")));
            r.setAvgLoad5(Float.parseFloat(e.getChildText("avgLoad5")));
            r.setAvgLoad15(Float.parseFloat(e.getChildText("avgLoad15")));
            this.rmgs.add(r);
        }
    }

    public List<Rmg> getRmgs() {
        return this.rmgs;
    }

    public class Rmg {
        private String name;
        private String localTime;
        private int nodesUp;
        private int nodesDown;
        private float avgLoad1;
        private float avgLoad5;
        private float avgLoad15;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLocalTime() {
            return this.localTime;
        }

        public void setLocalTime(String localTime) {
            this.localTime = localTime;
        }

        public int getNodesUp() {
            return this.nodesUp;
        }

        public void setNodesUp(int nodesUp) {
            this.nodesUp = nodesUp;
        }

        public int getNodesDown() {
            return this.nodesDown;
        }

        public void setNodesDown(int nodesDown) {
            this.nodesDown = nodesDown;
        }

        public float getAvgLoad1() {
            return this.avgLoad1;
        }

        public void setAvgLoad1(float avgLoad1) {
            this.avgLoad1 = avgLoad1;
        }

        public float getAvgLoad5() {
            return this.avgLoad5;
        }

        public void setAvgLoad5(float avgLoad5) {
            this.avgLoad5 = avgLoad5;
        }

        public float getAvgLoad15() {
            return this.avgLoad15;
        }

        public void setAvgLoad15(float avgLoad15) {
            this.avgLoad15 = avgLoad15;
        }

        public String toString() {
            return "Rmg [name=" + this.name + ", localTime=" + this.localTime + ", nodesUp=" + this.nodesUp + ", nodesDown=" + this.nodesDown + ", avgLoad1=" + this.avgLoad1 + ", avgLoad5=" + this.avgLoad5 + ", avgLoad15=" + this.avgLoad15 + "]";
        }
    }
}

