/*
 * Decompiled with CFR 0.152.
 */
package com.emc.esu.sysmgmt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class SysMgmtUtils {
    private static final Logger l4j = Logger.getLogger(SysMgmtUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readResponse(HttpURLConnection con) throws IOException {
        InputStream in = null;
        if (con.getResponseCode() > 299) {
            in = con.getErrorStream();
            if (in == null) {
                in = con.getInputStream();
            }
        } else {
            in = con.getInputStream();
        }
        if (in == null) {
            return new byte[0];
        }
        try {
            int contentLength = con.getContentLength();
            if (contentLength != -1) {
                int read2;
                byte[] output = new byte[con.getContentLength()];
                for (int c = 0; c < contentLength; c += read2) {
                    read2 = in.read(output, c, contentLength - c);
                    if (read2 != -1) continue;
                    throw new EOFException("EOF reading response at position " + c + " size " + (contentLength - c));
                }
                byte[] read2 = output;
                return read2;
            }
            l4j.debug((Object)"Content length is unknown.  Buffering output.");
            byte[] buffer = new byte[4096];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int c = 0;
            while ((c = in.read(buffer)) != -1) {
                baos.write(buffer, 0, c);
            }
            baos.close();
            l4j.debug((Object)("Buffered " + baos.size() + " response bytes"));
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static Document parseResponseXml(HttpURLConnection con) throws IOException, JDOMException {
        byte[] data = SysMgmtUtils.readResponse(con);
        if (l4j.isDebugEnabled()) {
            l4j.debug((Object)("Response: " + new String(data, "UTF-8")));
        }
        SAXBuilder sb = new SAXBuilder();
        Document d = sb.build((InputStream)new ByteArrayInputStream(data));
        return d;
    }
}

