/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.policy.internal;

import com.amazonaws.auth.policy.Action;
import com.amazonaws.auth.policy.Condition;
import com.amazonaws.auth.policy.Policy;
import com.amazonaws.auth.policy.Principal;
import com.amazonaws.auth.policy.Resource;
import com.amazonaws.auth.policy.Statement;
import com.amazonaws.util.json.JSONArray;
import com.amazonaws.util.json.JSONException;
import com.amazonaws.util.json.JSONObject;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class JsonPolicyReader {
    public Policy createPolicyFromJsonString(String jsonString) {
        if (jsonString == null) {
            throw new IllegalArgumentException("JSON string cannot be null");
        }
        Policy policy = new Policy();
        LinkedList<Statement> statements = new LinkedList<Statement>();
        try {
            JSONObject jPolicy = new JSONObject(jsonString);
            if (Arrays.asList(JSONObject.getNames(jPolicy)).contains("Id")) {
                policy.setId(jPolicy.getString("Id"));
            }
            JSONArray jStatements = jPolicy.getJSONArray("Statement");
            for (int index = 0; index < jStatements.length(); ++index) {
                Statement statement = this.convertStatement(jStatements.getJSONObject(index));
                if (statement == null) continue;
                statements.add(statement);
            }
        }
        catch (Exception e) {
            String message = "Unable to generate policy object fron JSON string " + e.getMessage();
            throw new IllegalArgumentException(message, e);
        }
        policy.setStatements(statements);
        return policy;
    }

    private Statement convertStatement(JSONObject jStatement) throws JSONException {
        if (!Arrays.asList(JSONObject.getNames(jStatement)).contains("Effect")) {
            return null;
        }
        String jEffect = jStatement.getString("Effect");
        Statement statement = "Allow".equals(jEffect) ? new Statement(Statement.Effect.Allow) : new Statement(Statement.Effect.Deny);
        if (Arrays.asList(JSONObject.getNames(jStatement)).contains("Sid")) {
            statement.setId(jStatement.getString("Sid"));
        }
        this.convertActions(statement, jStatement);
        this.convertResources(statement, jStatement);
        this.convertCondition(statement, jStatement);
        this.convertPrincipals(statement, jStatement);
        return statement;
    }

    private void convertPrincipals(Statement statement, JSONObject jStatement) throws JSONException {
        String[] fields;
        if (!Arrays.asList(JSONObject.getNames(jStatement)).contains("Principal")) {
            return;
        }
        if (jStatement.optString("Principal").equals("*")) {
            statement.setPrincipals(Principal.All);
            return;
        }
        if (statement.getPrincipals() == null) {
            statement.setPrincipals(new LinkedList<Principal>());
        }
        JSONObject jPrincipals = jStatement.getJSONObject("Principal");
        for (String field : fields = JSONObject.getNames(jPrincipals)) {
            String serviceId = jPrincipals.optString(field);
            if (serviceId != null && serviceId.length() > 0) {
                if (field.equalsIgnoreCase("AWS")) {
                    statement.getPrincipals().add(new Principal(serviceId));
                    continue;
                }
                if (field.equalsIgnoreCase("Service")) {
                    statement.getPrincipals().add(new Principal(Principal.Services.fromString(serviceId)));
                    continue;
                }
                if (!field.equalsIgnoreCase("Federated")) continue;
                if (Principal.WebIdentityProviders.fromString(serviceId) != null) {
                    statement.getPrincipals().add(new Principal(Principal.WebIdentityProviders.fromString(serviceId)));
                    continue;
                }
                statement.getPrincipals().add(new Principal("Federated", serviceId));
                continue;
            }
            JSONArray jPrincipal = jPrincipals.getJSONArray(field);
            this.convertPrincipalRecord(field, statement, jPrincipal);
        }
    }

    private void convertPrincipalRecord(String schema, Statement statement, JSONArray jPrincipal) throws JSONException {
        Principal principal = null;
        for (int index = 0; index < jPrincipal.length(); ++index) {
            if (schema.equals("AWS")) {
                if (jPrincipal.getString(index).equals("*")) {
                    principal = Principal.AllUsers;
                }
                principal = new Principal(jPrincipal.getString(index));
            } else if (schema.equals("Service")) {
                principal = new Principal(Principal.Services.fromString(jPrincipal.getString(index)));
            }
            statement.getPrincipals().add(principal);
        }
    }

    private void convertCondition(Statement statement, JSONObject jStatement) throws JSONException {
        String[] types;
        if (!Arrays.asList(JSONObject.getNames(jStatement)).contains("Condition")) {
            return;
        }
        JSONObject jConditions = jStatement.getJSONObject("Condition");
        LinkedList<Condition> conditions = new LinkedList<Condition>();
        for (String type : types = JSONObject.getNames(jConditions)) {
            JSONObject jCondition = jConditions.getJSONObject(type);
            this.convertConditionRecord(conditions, type, jCondition);
        }
        statement.setConditions(conditions);
    }

    private void convertConditionRecord(List<Condition> conditions, String type, JSONObject jCondition) throws JSONException {
        String[] keys;
        LinkedList<String> values = new LinkedList<String>();
        for (String key : keys = JSONObject.getNames(jCondition)) {
            String value = jCondition.optString(key);
            if (value != null && value.length() > 0) {
                values.add(value);
            } else {
                JSONArray jValues = jCondition.getJSONArray(key);
                for (int index = 0; index < jValues.length(); ++index) {
                    values.add(jValues.getString(index));
                }
            }
            conditions.add(new Condition().withType(type).withConditionKey(key).withValues(values));
        }
    }

    private void convertActions(Statement statement, JSONObject jStatement) throws JSONException {
        if (!Arrays.asList(JSONObject.getNames(jStatement)).contains("Action")) {
            return;
        }
        String actionName = null;
        LinkedList<Action> actions = new LinkedList<Action>();
        actionName = jStatement.optString("Action");
        if (actionName != null && actionName.length() > 0) {
            actions.add(new NamedAction(actionName));
            statement.setActions(actions);
            return;
        }
        JSONArray jActions = jStatement.getJSONArray("Action");
        for (int index = 0; index < jActions.length(); ++index) {
            actionName = jActions.getString(index);
            actions.add(new NamedAction(actionName));
        }
        statement.setActions(actions);
    }

    private void convertResources(Statement statement, JSONObject jStatement) throws JSONException {
        if (!Arrays.asList(JSONObject.getNames(jStatement)).contains("Resource")) {
            return;
        }
        LinkedList<Resource> resources = new LinkedList<Resource>();
        String resourceId = jStatement.optString("Resource");
        if (resourceId != null && resourceId.length() > 0) {
            resources.add(new Resource(resourceId));
            statement.setResources(resources);
            return;
        }
        JSONArray jResources = jStatement.getJSONArray("Resource");
        for (int index = 0; index < jResources.length(); ++index) {
            resources.add(new Resource(jResources.getString(index)));
        }
        statement.setResources(resources);
    }

    private static class NamedAction
    implements Action {
        private String actionName;

        public NamedAction(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public String getActionName() {
            return this.actionName;
        }
    }
}

