/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public class DefaultErrorResponseHandler
implements HttpResponseHandler<AmazonServiceException> {
    private List<Unmarshaller<AmazonServiceException, Node>> unmarshallerList;

    public DefaultErrorResponseHandler(List<Unmarshaller<AmazonServiceException, Node>> unmarshallerList) {
        this.unmarshallerList = unmarshallerList;
    }

    @Override
    public AmazonServiceException handle(HttpResponse errorResponse) throws Exception {
        Document document;
        try {
            document = XpathUtils.documentFrom(errorResponse.getContent());
        }
        catch (SAXParseException e) {
            AmazonServiceException exception = new AmazonServiceException(String.format("Unable to unmarshall error response (%s)", e.getMessage()), e);
            exception.setErrorCode(String.format("%s %s", errorResponse.getStatusCode(), errorResponse.getStatusText()));
            exception.setErrorType(AmazonServiceException.ErrorType.Unknown);
            exception.setStatusCode(errorResponse.getStatusCode());
            return exception;
        }
        for (Unmarshaller<AmazonServiceException, Node> unmarshaller : this.unmarshallerList) {
            AmazonServiceException ase = unmarshaller.unmarshall(document);
            if (ase == null) continue;
            ase.setStatusCode(errorResponse.getStatusCode());
            return ase;
        }
        throw new AmazonClientException("Unable to unmarshall error response from service");
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }
}

