/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cloudformation.model.Capability;
import com.amazonaws.services.cloudformation.model.Parameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateStackRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String stackName;
    private String templateBody;
    private String templateURL;
    private String stackPolicyDuringUpdateBody;
    private String stackPolicyDuringUpdateURL;
    private ListWithAutoConstructFlag<Parameter> parameters;
    private ListWithAutoConstructFlag<String> capabilities;
    private String stackPolicyBody;
    private String stackPolicyURL;

    public String getStackName() {
        return this.stackName;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }

    public UpdateStackRequest withStackName(String stackName) {
        this.stackName = stackName;
        return this;
    }

    public String getTemplateBody() {
        return this.templateBody;
    }

    public void setTemplateBody(String templateBody) {
        this.templateBody = templateBody;
    }

    public UpdateStackRequest withTemplateBody(String templateBody) {
        this.templateBody = templateBody;
        return this;
    }

    public String getTemplateURL() {
        return this.templateURL;
    }

    public void setTemplateURL(String templateURL) {
        this.templateURL = templateURL;
    }

    public UpdateStackRequest withTemplateURL(String templateURL) {
        this.templateURL = templateURL;
        return this;
    }

    public String getStackPolicyDuringUpdateBody() {
        return this.stackPolicyDuringUpdateBody;
    }

    public void setStackPolicyDuringUpdateBody(String stackPolicyDuringUpdateBody) {
        this.stackPolicyDuringUpdateBody = stackPolicyDuringUpdateBody;
    }

    public UpdateStackRequest withStackPolicyDuringUpdateBody(String stackPolicyDuringUpdateBody) {
        this.stackPolicyDuringUpdateBody = stackPolicyDuringUpdateBody;
        return this;
    }

    public String getStackPolicyDuringUpdateURL() {
        return this.stackPolicyDuringUpdateURL;
    }

    public void setStackPolicyDuringUpdateURL(String stackPolicyDuringUpdateURL) {
        this.stackPolicyDuringUpdateURL = stackPolicyDuringUpdateURL;
    }

    public UpdateStackRequest withStackPolicyDuringUpdateURL(String stackPolicyDuringUpdateURL) {
        this.stackPolicyDuringUpdateURL = stackPolicyDuringUpdateURL;
        return this;
    }

    public List<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ListWithAutoConstructFlag();
            this.parameters.setAutoConstruct(true);
        }
        return this.parameters;
    }

    public void setParameters(Collection<Parameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        ListWithAutoConstructFlag parametersCopy = new ListWithAutoConstructFlag(parameters.size());
        parametersCopy.addAll(parameters);
        this.parameters = parametersCopy;
    }

    public UpdateStackRequest withParameters(Parameter ... parameters) {
        if (this.getParameters() == null) {
            this.setParameters(new ArrayList<Parameter>(parameters.length));
        }
        for (Parameter value : parameters) {
            this.getParameters().add(value);
        }
        return this;
    }

    public UpdateStackRequest withParameters(Collection<Parameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
        } else {
            ListWithAutoConstructFlag parametersCopy = new ListWithAutoConstructFlag(parameters.size());
            parametersCopy.addAll(parameters);
            this.parameters = parametersCopy;
        }
        return this;
    }

    public List<String> getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new ListWithAutoConstructFlag();
            this.capabilities.setAutoConstruct(true);
        }
        return this.capabilities;
    }

    public void setCapabilities(Collection<String> capabilities) {
        if (capabilities == null) {
            this.capabilities = null;
            return;
        }
        ListWithAutoConstructFlag capabilitiesCopy = new ListWithAutoConstructFlag(capabilities.size());
        capabilitiesCopy.addAll(capabilities);
        this.capabilities = capabilitiesCopy;
    }

    public UpdateStackRequest withCapabilities(String ... capabilities) {
        if (this.getCapabilities() == null) {
            this.setCapabilities(new ArrayList<String>(capabilities.length));
        }
        for (String value : capabilities) {
            this.getCapabilities().add(value);
        }
        return this;
    }

    public UpdateStackRequest withCapabilities(Collection<String> capabilities) {
        if (capabilities == null) {
            this.capabilities = null;
        } else {
            ListWithAutoConstructFlag capabilitiesCopy = new ListWithAutoConstructFlag(capabilities.size());
            capabilitiesCopy.addAll(capabilities);
            this.capabilities = capabilitiesCopy;
        }
        return this;
    }

    public UpdateStackRequest withCapabilities(Capability ... capabilities) {
        ArrayList<String> capabilitiesCopy = new ArrayList<String>(capabilities.length);
        for (Capability member : capabilities) {
            capabilitiesCopy.add(member.toString());
        }
        if (this.getCapabilities() == null) {
            this.setCapabilities(capabilitiesCopy);
        } else {
            this.getCapabilities().addAll(capabilitiesCopy);
        }
        return this;
    }

    public String getStackPolicyBody() {
        return this.stackPolicyBody;
    }

    public void setStackPolicyBody(String stackPolicyBody) {
        this.stackPolicyBody = stackPolicyBody;
    }

    public UpdateStackRequest withStackPolicyBody(String stackPolicyBody) {
        this.stackPolicyBody = stackPolicyBody;
        return this;
    }

    public String getStackPolicyURL() {
        return this.stackPolicyURL;
    }

    public void setStackPolicyURL(String stackPolicyURL) {
        this.stackPolicyURL = stackPolicyURL;
    }

    public UpdateStackRequest withStackPolicyURL(String stackPolicyURL) {
        this.stackPolicyURL = stackPolicyURL;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStackName() != null) {
            sb.append("StackName: " + this.getStackName() + ",");
        }
        if (this.getTemplateBody() != null) {
            sb.append("TemplateBody: " + this.getTemplateBody() + ",");
        }
        if (this.getTemplateURL() != null) {
            sb.append("TemplateURL: " + this.getTemplateURL() + ",");
        }
        if (this.getStackPolicyDuringUpdateBody() != null) {
            sb.append("StackPolicyDuringUpdateBody: " + this.getStackPolicyDuringUpdateBody() + ",");
        }
        if (this.getStackPolicyDuringUpdateURL() != null) {
            sb.append("StackPolicyDuringUpdateURL: " + this.getStackPolicyDuringUpdateURL() + ",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: " + this.getParameters() + ",");
        }
        if (this.getCapabilities() != null) {
            sb.append("Capabilities: " + this.getCapabilities() + ",");
        }
        if (this.getStackPolicyBody() != null) {
            sb.append("StackPolicyBody: " + this.getStackPolicyBody() + ",");
        }
        if (this.getStackPolicyURL() != null) {
            sb.append("StackPolicyURL: " + this.getStackPolicyURL());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStackName() == null ? 0 : this.getStackName().hashCode());
        hashCode = 31 * hashCode + (this.getTemplateBody() == null ? 0 : this.getTemplateBody().hashCode());
        hashCode = 31 * hashCode + (this.getTemplateURL() == null ? 0 : this.getTemplateURL().hashCode());
        hashCode = 31 * hashCode + (this.getStackPolicyDuringUpdateBody() == null ? 0 : this.getStackPolicyDuringUpdateBody().hashCode());
        hashCode = 31 * hashCode + (this.getStackPolicyDuringUpdateURL() == null ? 0 : this.getStackPolicyDuringUpdateURL().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : ((Object)this.getParameters()).hashCode());
        hashCode = 31 * hashCode + (this.getCapabilities() == null ? 0 : ((Object)this.getCapabilities()).hashCode());
        hashCode = 31 * hashCode + (this.getStackPolicyBody() == null ? 0 : this.getStackPolicyBody().hashCode());
        hashCode = 31 * hashCode + (this.getStackPolicyURL() == null ? 0 : this.getStackPolicyURL().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStackRequest)) {
            return false;
        }
        UpdateStackRequest other = (UpdateStackRequest)obj;
        if (other.getStackName() == null ^ this.getStackName() == null) {
            return false;
        }
        if (other.getStackName() != null && !other.getStackName().equals(this.getStackName())) {
            return false;
        }
        if (other.getTemplateBody() == null ^ this.getTemplateBody() == null) {
            return false;
        }
        if (other.getTemplateBody() != null && !other.getTemplateBody().equals(this.getTemplateBody())) {
            return false;
        }
        if (other.getTemplateURL() == null ^ this.getTemplateURL() == null) {
            return false;
        }
        if (other.getTemplateURL() != null && !other.getTemplateURL().equals(this.getTemplateURL())) {
            return false;
        }
        if (other.getStackPolicyDuringUpdateBody() == null ^ this.getStackPolicyDuringUpdateBody() == null) {
            return false;
        }
        if (other.getStackPolicyDuringUpdateBody() != null && !other.getStackPolicyDuringUpdateBody().equals(this.getStackPolicyDuringUpdateBody())) {
            return false;
        }
        if (other.getStackPolicyDuringUpdateURL() == null ^ this.getStackPolicyDuringUpdateURL() == null) {
            return false;
        }
        if (other.getStackPolicyDuringUpdateURL() != null && !other.getStackPolicyDuringUpdateURL().equals(this.getStackPolicyDuringUpdateURL())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !((Object)other.getParameters()).equals(this.getParameters())) {
            return false;
        }
        if (other.getCapabilities() == null ^ this.getCapabilities() == null) {
            return false;
        }
        if (other.getCapabilities() != null && !((Object)other.getCapabilities()).equals(this.getCapabilities())) {
            return false;
        }
        if (other.getStackPolicyBody() == null ^ this.getStackPolicyBody() == null) {
            return false;
        }
        if (other.getStackPolicyBody() != null && !other.getStackPolicyBody().equals(this.getStackPolicyBody())) {
            return false;
        }
        if (other.getStackPolicyURL() == null ^ this.getStackPolicyURL() == null) {
            return false;
        }
        return other.getStackPolicyURL() == null || other.getStackPolicyURL().equals(this.getStackPolicyURL());
    }
}

