/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cloudwatch.model.DimensionFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListMetricsRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String namespace;
    private String metricName;
    private ListWithAutoConstructFlag<DimensionFilter> dimensions;
    private String nextToken;

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public ListMetricsRequest withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public ListMetricsRequest withMetricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    public List<DimensionFilter> getDimensions() {
        if (this.dimensions == null) {
            this.dimensions = new ListWithAutoConstructFlag();
            this.dimensions.setAutoConstruct(true);
        }
        return this.dimensions;
    }

    public void setDimensions(Collection<DimensionFilter> dimensions) {
        if (dimensions == null) {
            this.dimensions = null;
            return;
        }
        ListWithAutoConstructFlag dimensionsCopy = new ListWithAutoConstructFlag(dimensions.size());
        dimensionsCopy.addAll(dimensions);
        this.dimensions = dimensionsCopy;
    }

    public ListMetricsRequest withDimensions(DimensionFilter ... dimensions) {
        if (this.getDimensions() == null) {
            this.setDimensions(new ArrayList<DimensionFilter>(dimensions.length));
        }
        for (DimensionFilter value : dimensions) {
            this.getDimensions().add(value);
        }
        return this;
    }

    public ListMetricsRequest withDimensions(Collection<DimensionFilter> dimensions) {
        if (dimensions == null) {
            this.dimensions = null;
        } else {
            ListWithAutoConstructFlag dimensionsCopy = new ListWithAutoConstructFlag(dimensions.size());
            dimensionsCopy.addAll(dimensions);
            this.dimensions = dimensionsCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListMetricsRequest withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNamespace() != null) {
            sb.append("Namespace: " + this.getNamespace() + ",");
        }
        if (this.getMetricName() != null) {
            sb.append("MetricName: " + this.getMetricName() + ",");
        }
        if (this.getDimensions() != null) {
            sb.append("Dimensions: " + this.getDimensions() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getMetricName() == null ? 0 : this.getMetricName().hashCode());
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : ((Object)this.getDimensions()).hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMetricsRequest)) {
            return false;
        }
        ListMetricsRequest other = (ListMetricsRequest)obj;
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getMetricName() == null ^ this.getMetricName() == null) {
            return false;
        }
        if (other.getMetricName() != null && !other.getMetricName().equals(this.getMetricName())) {
            return false;
        }
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        if (other.getDimensions() != null && !((Object)other.getDimensions()).equals(this.getDimensions())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }
}

