/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.datapipeline.model.Field;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PipelineDescription
implements Serializable {
    private String pipelineId;
    private String name;
    private ListWithAutoConstructFlag<Field> fields;
    private String description;

    public String getPipelineId() {
        return this.pipelineId;
    }

    public void setPipelineId(String pipelineId) {
        this.pipelineId = pipelineId;
    }

    public PipelineDescription withPipelineId(String pipelineId) {
        this.pipelineId = pipelineId;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PipelineDescription withName(String name) {
        this.name = name;
        return this;
    }

    public List<Field> getFields() {
        if (this.fields == null) {
            this.fields = new ListWithAutoConstructFlag();
            this.fields.setAutoConstruct(true);
        }
        return this.fields;
    }

    public void setFields(Collection<Field> fields) {
        if (fields == null) {
            this.fields = null;
            return;
        }
        ListWithAutoConstructFlag fieldsCopy = new ListWithAutoConstructFlag(fields.size());
        fieldsCopy.addAll(fields);
        this.fields = fieldsCopy;
    }

    public PipelineDescription withFields(Field ... fields) {
        if (this.getFields() == null) {
            this.setFields(new ArrayList<Field>(fields.length));
        }
        for (Field value : fields) {
            this.getFields().add(value);
        }
        return this;
    }

    public PipelineDescription withFields(Collection<Field> fields) {
        if (fields == null) {
            this.fields = null;
        } else {
            ListWithAutoConstructFlag fieldsCopy = new ListWithAutoConstructFlag(fields.size());
            fieldsCopy.addAll(fields);
            this.fields = fieldsCopy;
        }
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PipelineDescription withDescription(String description) {
        this.description = description;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPipelineId() != null) {
            sb.append("PipelineId: " + this.getPipelineId() + ",");
        }
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getFields() != null) {
            sb.append("Fields: " + this.getFields() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPipelineId() == null ? 0 : this.getPipelineId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getFields() == null ? 0 : ((Object)this.getFields()).hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineDescription)) {
            return false;
        }
        PipelineDescription other = (PipelineDescription)obj;
        if (other.getPipelineId() == null ^ this.getPipelineId() == null) {
            return false;
        }
        if (other.getPipelineId() != null && !other.getPipelineId().equals(this.getPipelineId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getFields() == null ^ this.getFields() == null) {
            return false;
        }
        if (other.getFields() != null && !((Object)other.getFields()).equals(this.getFields())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        return other.getDescription() == null || other.getDescription().equals(this.getDescription());
    }
}

