/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SetStatusRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String pipelineId;
    private ListWithAutoConstructFlag<String> objectIds;
    private String status;

    public String getPipelineId() {
        return this.pipelineId;
    }

    public void setPipelineId(String pipelineId) {
        this.pipelineId = pipelineId;
    }

    public SetStatusRequest withPipelineId(String pipelineId) {
        this.pipelineId = pipelineId;
        return this;
    }

    public List<String> getObjectIds() {
        if (this.objectIds == null) {
            this.objectIds = new ListWithAutoConstructFlag();
            this.objectIds.setAutoConstruct(true);
        }
        return this.objectIds;
    }

    public void setObjectIds(Collection<String> objectIds) {
        if (objectIds == null) {
            this.objectIds = null;
            return;
        }
        ListWithAutoConstructFlag objectIdsCopy = new ListWithAutoConstructFlag(objectIds.size());
        objectIdsCopy.addAll(objectIds);
        this.objectIds = objectIdsCopy;
    }

    public SetStatusRequest withObjectIds(String ... objectIds) {
        if (this.getObjectIds() == null) {
            this.setObjectIds(new ArrayList<String>(objectIds.length));
        }
        for (String value : objectIds) {
            this.getObjectIds().add(value);
        }
        return this;
    }

    public SetStatusRequest withObjectIds(Collection<String> objectIds) {
        if (objectIds == null) {
            this.objectIds = null;
        } else {
            ListWithAutoConstructFlag objectIdsCopy = new ListWithAutoConstructFlag(objectIds.size());
            objectIdsCopy.addAll(objectIds);
            this.objectIds = objectIdsCopy;
        }
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public SetStatusRequest withStatus(String status) {
        this.status = status;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPipelineId() != null) {
            sb.append("PipelineId: " + this.getPipelineId() + ",");
        }
        if (this.getObjectIds() != null) {
            sb.append("ObjectIds: " + this.getObjectIds() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPipelineId() == null ? 0 : this.getPipelineId().hashCode());
        hashCode = 31 * hashCode + (this.getObjectIds() == null ? 0 : ((Object)this.getObjectIds()).hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetStatusRequest)) {
            return false;
        }
        SetStatusRequest other = (SetStatusRequest)obj;
        if (other.getPipelineId() == null ^ this.getPipelineId() == null) {
            return false;
        }
        if (other.getPipelineId() != null && !other.getPipelineId().equals(this.getPipelineId())) {
            return false;
        }
        if (other.getObjectIds() == null ^ this.getObjectIds() == null) {
            return false;
        }
        if (other.getObjectIds() != null && !((Object)other.getObjectIds()).equals(this.getObjectIds())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        return other.getStatus() == null || other.getStatus().equals(this.getStatus());
    }
}

