/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DescribeVirtualInterfacesRequestMarshaller
implements Marshaller<Request<DescribeVirtualInterfacesRequest>, DescribeVirtualInterfacesRequest> {
    @Override
    public Request<DescribeVirtualInterfacesRequest> marshall(DescribeVirtualInterfacesRequest describeVirtualInterfacesRequest) {
        if (describeVirtualInterfacesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeVirtualInterfacesRequest> request = new DefaultRequest<DescribeVirtualInterfacesRequest>(describeVirtualInterfacesRequest, "AmazonDirectConnect");
        String target = "OvertureService.DescribeVirtualInterfaces";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.1");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (describeVirtualInterfacesRequest.getConnectionId() != null) {
                jsonWriter.key("connectionId").value(describeVirtualInterfacesRequest.getConnectionId());
            }
            if (describeVirtualInterfacesRequest.getVirtualInterfaceId() != null) {
                jsonWriter.key("virtualInterfaceId").value(describeVirtualInterfacesRequest.getVirtualInterfaceId());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

