/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.Select;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String tableName;
    private String indexName;
    private String select;
    private ListWithAutoConstructFlag<String> attributesToGet;
    private Integer limit;
    private Boolean consistentRead;
    private Map<String, Condition> keyConditions;
    private Boolean scanIndexForward;
    private Map<String, AttributeValue> exclusiveStartKey;
    private String returnConsumedCapacity;

    public QueryRequest() {
    }

    public QueryRequest(String tableName) {
        this.setTableName(tableName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public QueryRequest withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public QueryRequest withIndexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public String getSelect() {
        return this.select;
    }

    public void setSelect(String select) {
        this.select = select;
    }

    public QueryRequest withSelect(String select) {
        this.select = select;
        return this;
    }

    public void setSelect(Select select) {
        this.select = select.toString();
    }

    public QueryRequest withSelect(Select select) {
        this.select = select.toString();
        return this;
    }

    public List<String> getAttributesToGet() {
        return this.attributesToGet;
    }

    public void setAttributesToGet(Collection<String> attributesToGet) {
        if (attributesToGet == null) {
            this.attributesToGet = null;
            return;
        }
        ListWithAutoConstructFlag attributesToGetCopy = new ListWithAutoConstructFlag(attributesToGet.size());
        attributesToGetCopy.addAll(attributesToGet);
        this.attributesToGet = attributesToGetCopy;
    }

    public QueryRequest withAttributesToGet(String ... attributesToGet) {
        if (this.getAttributesToGet() == null) {
            this.setAttributesToGet(new ArrayList<String>(attributesToGet.length));
        }
        for (String value : attributesToGet) {
            this.getAttributesToGet().add(value);
        }
        return this;
    }

    public QueryRequest withAttributesToGet(Collection<String> attributesToGet) {
        if (attributesToGet == null) {
            this.attributesToGet = null;
        } else {
            ListWithAutoConstructFlag attributesToGetCopy = new ListWithAutoConstructFlag(attributesToGet.size());
            attributesToGetCopy.addAll(attributesToGet);
            this.attributesToGet = attributesToGetCopy;
        }
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public QueryRequest withLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Boolean isConsistentRead() {
        return this.consistentRead;
    }

    public void setConsistentRead(Boolean consistentRead) {
        this.consistentRead = consistentRead;
    }

    public QueryRequest withConsistentRead(Boolean consistentRead) {
        this.consistentRead = consistentRead;
        return this;
    }

    public Boolean getConsistentRead() {
        return this.consistentRead;
    }

    public Map<String, Condition> getKeyConditions() {
        return this.keyConditions;
    }

    public void setKeyConditions(Map<String, Condition> keyConditions) {
        this.keyConditions = keyConditions;
    }

    public QueryRequest withKeyConditions(Map<String, Condition> keyConditions) {
        this.setKeyConditions(keyConditions);
        return this;
    }

    public QueryRequest addKeyConditionsEntry(String key, Condition value) {
        if (null == this.keyConditions) {
            this.keyConditions = new HashMap<String, Condition>();
        }
        if (this.keyConditions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.keyConditions.put(key, value);
        return this;
    }

    public QueryRequest clearKeyConditionsEntries() {
        this.keyConditions = null;
        return this;
    }

    public Boolean isScanIndexForward() {
        return this.scanIndexForward;
    }

    public void setScanIndexForward(Boolean scanIndexForward) {
        this.scanIndexForward = scanIndexForward;
    }

    public QueryRequest withScanIndexForward(Boolean scanIndexForward) {
        this.scanIndexForward = scanIndexForward;
        return this;
    }

    public Boolean getScanIndexForward() {
        return this.scanIndexForward;
    }

    public Map<String, AttributeValue> getExclusiveStartKey() {
        return this.exclusiveStartKey;
    }

    public void setExclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
        this.exclusiveStartKey = exclusiveStartKey;
    }

    public QueryRequest withExclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
        this.setExclusiveStartKey(exclusiveStartKey);
        return this;
    }

    public void setExclusiveStartKey(Map.Entry<String, AttributeValue> hashKey, Map.Entry<String, AttributeValue> rangeKey) throws IllegalArgumentException {
        HashMap<String, AttributeValue> exclusiveStartKey = new HashMap<String, AttributeValue>();
        if (hashKey == null) {
            throw new IllegalArgumentException("hashKey must be non-null object.");
        }
        exclusiveStartKey.put(hashKey.getKey(), hashKey.getValue());
        if (rangeKey != null) {
            exclusiveStartKey.put(rangeKey.getKey(), rangeKey.getValue());
        }
        this.setExclusiveStartKey(exclusiveStartKey);
    }

    public QueryRequest withExclusiveStartKey(Map.Entry<String, AttributeValue> hashKey, Map.Entry<String, AttributeValue> rangeKey) throws IllegalArgumentException {
        this.setExclusiveStartKey(hashKey, rangeKey);
        return this;
    }

    public QueryRequest addExclusiveStartKeyEntry(String key, AttributeValue value) {
        if (null == this.exclusiveStartKey) {
            this.exclusiveStartKey = new HashMap<String, AttributeValue>();
        }
        if (this.exclusiveStartKey.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.exclusiveStartKey.put(key, value);
        return this;
    }

    public QueryRequest clearExclusiveStartKeyEntries() {
        this.exclusiveStartKey = null;
        return this;
    }

    public String getReturnConsumedCapacity() {
        return this.returnConsumedCapacity;
    }

    public void setReturnConsumedCapacity(String returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity;
    }

    public QueryRequest withReturnConsumedCapacity(String returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity;
        return this;
    }

    public void setReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
    }

    public QueryRequest withReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTableName() != null) {
            sb.append("TableName: " + this.getTableName() + ",");
        }
        if (this.getIndexName() != null) {
            sb.append("IndexName: " + this.getIndexName() + ",");
        }
        if (this.getSelect() != null) {
            sb.append("Select: " + this.getSelect() + ",");
        }
        if (this.getAttributesToGet() != null) {
            sb.append("AttributesToGet: " + this.getAttributesToGet() + ",");
        }
        if (this.getLimit() != null) {
            sb.append("Limit: " + this.getLimit() + ",");
        }
        if (this.isConsistentRead() != null) {
            sb.append("ConsistentRead: " + this.isConsistentRead() + ",");
        }
        if (this.getKeyConditions() != null) {
            sb.append("KeyConditions: " + this.getKeyConditions() + ",");
        }
        if (this.isScanIndexForward() != null) {
            sb.append("ScanIndexForward: " + this.isScanIndexForward() + ",");
        }
        if (this.getExclusiveStartKey() != null) {
            sb.append("ExclusiveStartKey: " + this.getExclusiveStartKey() + ",");
        }
        if (this.getReturnConsumedCapacity() != null) {
            sb.append("ReturnConsumedCapacity: " + this.getReturnConsumedCapacity());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        hashCode = 31 * hashCode + (this.getIndexName() == null ? 0 : this.getIndexName().hashCode());
        hashCode = 31 * hashCode + (this.getSelect() == null ? 0 : this.getSelect().hashCode());
        hashCode = 31 * hashCode + (this.getAttributesToGet() == null ? 0 : ((Object)this.getAttributesToGet()).hashCode());
        hashCode = 31 * hashCode + (this.getLimit() == null ? 0 : this.getLimit().hashCode());
        hashCode = 31 * hashCode + (this.isConsistentRead() == null ? 0 : this.isConsistentRead().hashCode());
        hashCode = 31 * hashCode + (this.getKeyConditions() == null ? 0 : ((Object)this.getKeyConditions()).hashCode());
        hashCode = 31 * hashCode + (this.isScanIndexForward() == null ? 0 : this.isScanIndexForward().hashCode());
        hashCode = 31 * hashCode + (this.getExclusiveStartKey() == null ? 0 : ((Object)this.getExclusiveStartKey()).hashCode());
        hashCode = 31 * hashCode + (this.getReturnConsumedCapacity() == null ? 0 : this.getReturnConsumedCapacity().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryRequest)) {
            return false;
        }
        QueryRequest other = (QueryRequest)obj;
        if (other.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (other.getTableName() != null && !other.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (other.getIndexName() == null ^ this.getIndexName() == null) {
            return false;
        }
        if (other.getIndexName() != null && !other.getIndexName().equals(this.getIndexName())) {
            return false;
        }
        if (other.getSelect() == null ^ this.getSelect() == null) {
            return false;
        }
        if (other.getSelect() != null && !other.getSelect().equals(this.getSelect())) {
            return false;
        }
        if (other.getAttributesToGet() == null ^ this.getAttributesToGet() == null) {
            return false;
        }
        if (other.getAttributesToGet() != null && !((Object)other.getAttributesToGet()).equals(this.getAttributesToGet())) {
            return false;
        }
        if (other.getLimit() == null ^ this.getLimit() == null) {
            return false;
        }
        if (other.getLimit() != null && !other.getLimit().equals(this.getLimit())) {
            return false;
        }
        if (other.isConsistentRead() == null ^ this.isConsistentRead() == null) {
            return false;
        }
        if (other.isConsistentRead() != null && !other.isConsistentRead().equals(this.isConsistentRead())) {
            return false;
        }
        if (other.getKeyConditions() == null ^ this.getKeyConditions() == null) {
            return false;
        }
        if (other.getKeyConditions() != null && !((Object)other.getKeyConditions()).equals(this.getKeyConditions())) {
            return false;
        }
        if (other.isScanIndexForward() == null ^ this.isScanIndexForward() == null) {
            return false;
        }
        if (other.isScanIndexForward() != null && !other.isScanIndexForward().equals(this.isScanIndexForward())) {
            return false;
        }
        if (other.getExclusiveStartKey() == null ^ this.getExclusiveStartKey() == null) {
            return false;
        }
        if (other.getExclusiveStartKey() != null && !((Object)other.getExclusiveStartKey()).equals(this.getExclusiveStartKey())) {
            return false;
        }
        if (other.getReturnConsumedCapacity() == null ^ this.getReturnConsumedCapacity() == null) {
            return false;
        }
        return other.getReturnConsumedCapacity() == null || other.getReturnConsumedCapacity().equals(this.getReturnConsumedCapacity());
    }
}

