/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.transform.DescribeNetworkInterfacesRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeNetworkInterfacesRequest
extends AmazonWebServiceRequest
implements Serializable,
DryRunSupportedRequest<DescribeNetworkInterfacesRequest> {
    private ListWithAutoConstructFlag<String> networkInterfaceIds;
    private ListWithAutoConstructFlag<Filter> filters;

    public List<String> getNetworkInterfaceIds() {
        if (this.networkInterfaceIds == null) {
            this.networkInterfaceIds = new ListWithAutoConstructFlag();
            this.networkInterfaceIds.setAutoConstruct(true);
        }
        return this.networkInterfaceIds;
    }

    public void setNetworkInterfaceIds(Collection<String> networkInterfaceIds) {
        if (networkInterfaceIds == null) {
            this.networkInterfaceIds = null;
            return;
        }
        ListWithAutoConstructFlag networkInterfaceIdsCopy = new ListWithAutoConstructFlag(networkInterfaceIds.size());
        networkInterfaceIdsCopy.addAll(networkInterfaceIds);
        this.networkInterfaceIds = networkInterfaceIdsCopy;
    }

    public DescribeNetworkInterfacesRequest withNetworkInterfaceIds(String ... networkInterfaceIds) {
        if (this.getNetworkInterfaceIds() == null) {
            this.setNetworkInterfaceIds(new ArrayList<String>(networkInterfaceIds.length));
        }
        for (String value : networkInterfaceIds) {
            this.getNetworkInterfaceIds().add(value);
        }
        return this;
    }

    public DescribeNetworkInterfacesRequest withNetworkInterfaceIds(Collection<String> networkInterfaceIds) {
        if (networkInterfaceIds == null) {
            this.networkInterfaceIds = null;
        } else {
            ListWithAutoConstructFlag networkInterfaceIdsCopy = new ListWithAutoConstructFlag(networkInterfaceIds.size());
            networkInterfaceIdsCopy.addAll(networkInterfaceIds);
            this.networkInterfaceIds = networkInterfaceIdsCopy;
        }
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ListWithAutoConstructFlag();
            this.filters.setAutoConstruct(true);
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
        filtersCopy.addAll(filters);
        this.filters = filtersCopy;
    }

    public DescribeNetworkInterfacesRequest withFilters(Filter ... filters) {
        if (this.getFilters() == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter value : filters) {
            this.getFilters().add(value);
        }
        return this;
    }

    public DescribeNetworkInterfacesRequest withFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
        } else {
            ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
            filtersCopy.addAll(filters);
            this.filters = filtersCopy;
        }
        return this;
    }

    @Override
    public Request<DescribeNetworkInterfacesRequest> getDryRunRequest() {
        Request<DescribeNetworkInterfacesRequest> request = new DescribeNetworkInterfacesRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNetworkInterfaceIds() != null) {
            sb.append("NetworkInterfaceIds: " + this.getNetworkInterfaceIds() + ",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNetworkInterfaceIds() == null ? 0 : ((Object)this.getNetworkInterfaceIds()).hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : ((Object)this.getFilters()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkInterfacesRequest)) {
            return false;
        }
        DescribeNetworkInterfacesRequest other = (DescribeNetworkInterfacesRequest)obj;
        if (other.getNetworkInterfaceIds() == null ^ this.getNetworkInterfaceIds() == null) {
            return false;
        }
        if (other.getNetworkInterfaceIds() != null && !((Object)other.getNetworkInterfaceIds()).equals(this.getNetworkInterfaceIds())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        return other.getFilters() == null || ((Object)other.getFilters()).equals(this.getFilters());
    }
}

