/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.transform.DescribeSpotInstanceRequestsRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeSpotInstanceRequestsRequest
extends AmazonWebServiceRequest
implements Serializable,
DryRunSupportedRequest<DescribeSpotInstanceRequestsRequest> {
    private ListWithAutoConstructFlag<String> spotInstanceRequestIds;
    private ListWithAutoConstructFlag<Filter> filters;

    public List<String> getSpotInstanceRequestIds() {
        if (this.spotInstanceRequestIds == null) {
            this.spotInstanceRequestIds = new ListWithAutoConstructFlag();
            this.spotInstanceRequestIds.setAutoConstruct(true);
        }
        return this.spotInstanceRequestIds;
    }

    public void setSpotInstanceRequestIds(Collection<String> spotInstanceRequestIds) {
        if (spotInstanceRequestIds == null) {
            this.spotInstanceRequestIds = null;
            return;
        }
        ListWithAutoConstructFlag spotInstanceRequestIdsCopy = new ListWithAutoConstructFlag(spotInstanceRequestIds.size());
        spotInstanceRequestIdsCopy.addAll(spotInstanceRequestIds);
        this.spotInstanceRequestIds = spotInstanceRequestIdsCopy;
    }

    public DescribeSpotInstanceRequestsRequest withSpotInstanceRequestIds(String ... spotInstanceRequestIds) {
        if (this.getSpotInstanceRequestIds() == null) {
            this.setSpotInstanceRequestIds(new ArrayList<String>(spotInstanceRequestIds.length));
        }
        for (String value : spotInstanceRequestIds) {
            this.getSpotInstanceRequestIds().add(value);
        }
        return this;
    }

    public DescribeSpotInstanceRequestsRequest withSpotInstanceRequestIds(Collection<String> spotInstanceRequestIds) {
        if (spotInstanceRequestIds == null) {
            this.spotInstanceRequestIds = null;
        } else {
            ListWithAutoConstructFlag spotInstanceRequestIdsCopy = new ListWithAutoConstructFlag(spotInstanceRequestIds.size());
            spotInstanceRequestIdsCopy.addAll(spotInstanceRequestIds);
            this.spotInstanceRequestIds = spotInstanceRequestIdsCopy;
        }
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ListWithAutoConstructFlag();
            this.filters.setAutoConstruct(true);
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
        filtersCopy.addAll(filters);
        this.filters = filtersCopy;
    }

    public DescribeSpotInstanceRequestsRequest withFilters(Filter ... filters) {
        if (this.getFilters() == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter value : filters) {
            this.getFilters().add(value);
        }
        return this;
    }

    public DescribeSpotInstanceRequestsRequest withFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
        } else {
            ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
            filtersCopy.addAll(filters);
            this.filters = filtersCopy;
        }
        return this;
    }

    @Override
    public Request<DescribeSpotInstanceRequestsRequest> getDryRunRequest() {
        Request<DescribeSpotInstanceRequestsRequest> request = new DescribeSpotInstanceRequestsRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSpotInstanceRequestIds() != null) {
            sb.append("SpotInstanceRequestIds: " + this.getSpotInstanceRequestIds() + ",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSpotInstanceRequestIds() == null ? 0 : ((Object)this.getSpotInstanceRequestIds()).hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : ((Object)this.getFilters()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotInstanceRequestsRequest)) {
            return false;
        }
        DescribeSpotInstanceRequestsRequest other = (DescribeSpotInstanceRequestsRequest)obj;
        if (other.getSpotInstanceRequestIds() == null ^ this.getSpotInstanceRequestIds() == null) {
            return false;
        }
        if (other.getSpotInstanceRequestIds() != null && !((Object)other.getSpotInstanceRequestIds()).equals(this.getSpotInstanceRequestIds())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        return other.getFilters() == null || ((Object)other.getFilters()).equals(this.getFilters());
    }
}

