/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.DiskImage;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification;
import com.amazonaws.services.ec2.model.PlatformValues;
import com.amazonaws.services.ec2.model.transform.ImportInstanceRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ImportInstanceRequest
extends AmazonWebServiceRequest
implements Serializable,
DryRunSupportedRequest<ImportInstanceRequest> {
    private String description;
    private ImportInstanceLaunchSpecification launchSpecification;
    private ListWithAutoConstructFlag<DiskImage> diskImages;
    private String platform;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ImportInstanceRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    public ImportInstanceLaunchSpecification getLaunchSpecification() {
        return this.launchSpecification;
    }

    public void setLaunchSpecification(ImportInstanceLaunchSpecification launchSpecification) {
        this.launchSpecification = launchSpecification;
    }

    public ImportInstanceRequest withLaunchSpecification(ImportInstanceLaunchSpecification launchSpecification) {
        this.launchSpecification = launchSpecification;
        return this;
    }

    public List<DiskImage> getDiskImages() {
        if (this.diskImages == null) {
            this.diskImages = new ListWithAutoConstructFlag();
            this.diskImages.setAutoConstruct(true);
        }
        return this.diskImages;
    }

    public void setDiskImages(Collection<DiskImage> diskImages) {
        if (diskImages == null) {
            this.diskImages = null;
            return;
        }
        ListWithAutoConstructFlag diskImagesCopy = new ListWithAutoConstructFlag(diskImages.size());
        diskImagesCopy.addAll(diskImages);
        this.diskImages = diskImagesCopy;
    }

    public ImportInstanceRequest withDiskImages(DiskImage ... diskImages) {
        if (this.getDiskImages() == null) {
            this.setDiskImages(new ArrayList<DiskImage>(diskImages.length));
        }
        for (DiskImage value : diskImages) {
            this.getDiskImages().add(value);
        }
        return this;
    }

    public ImportInstanceRequest withDiskImages(Collection<DiskImage> diskImages) {
        if (diskImages == null) {
            this.diskImages = null;
        } else {
            ListWithAutoConstructFlag diskImagesCopy = new ListWithAutoConstructFlag(diskImages.size());
            diskImagesCopy.addAll(diskImages);
            this.diskImages = diskImagesCopy;
        }
        return this;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public ImportInstanceRequest withPlatform(String platform) {
        this.platform = platform;
        return this;
    }

    public void setPlatform(PlatformValues platform) {
        this.platform = platform.toString();
    }

    public ImportInstanceRequest withPlatform(PlatformValues platform) {
        this.platform = platform.toString();
        return this;
    }

    @Override
    public Request<ImportInstanceRequest> getDryRunRequest() {
        Request<ImportInstanceRequest> request = new ImportInstanceRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getLaunchSpecification() != null) {
            sb.append("LaunchSpecification: " + this.getLaunchSpecification() + ",");
        }
        if (this.getDiskImages() != null) {
            sb.append("DiskImages: " + this.getDiskImages() + ",");
        }
        if (this.getPlatform() != null) {
            sb.append("Platform: " + this.getPlatform());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchSpecification() == null ? 0 : this.getLaunchSpecification().hashCode());
        hashCode = 31 * hashCode + (this.getDiskImages() == null ? 0 : ((Object)this.getDiskImages()).hashCode());
        hashCode = 31 * hashCode + (this.getPlatform() == null ? 0 : this.getPlatform().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportInstanceRequest)) {
            return false;
        }
        ImportInstanceRequest other = (ImportInstanceRequest)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getLaunchSpecification() == null ^ this.getLaunchSpecification() == null) {
            return false;
        }
        if (other.getLaunchSpecification() != null && !other.getLaunchSpecification().equals(this.getLaunchSpecification())) {
            return false;
        }
        if (other.getDiskImages() == null ^ this.getDiskImages() == null) {
            return false;
        }
        if (other.getDiskImages() != null && !((Object)other.getDiskImages()).equals(this.getDiskImages())) {
            return false;
        }
        if (other.getPlatform() == null ^ this.getPlatform() == null) {
            return false;
        }
        return other.getPlatform() == null || other.getPlatform().equals(this.getPlatform());
    }
}

