/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateCacheClusterRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String cacheClusterId;
    private String replicationGroupId;
    private Integer numCacheNodes;
    private String cacheNodeType;
    private String engine;
    private String engineVersion;
    private String cacheParameterGroupName;
    private String cacheSubnetGroupName;
    private ListWithAutoConstructFlag<String> cacheSecurityGroupNames;
    private ListWithAutoConstructFlag<String> securityGroupIds;
    private ListWithAutoConstructFlag<String> snapshotArns;
    private String preferredAvailabilityZone;
    private String preferredMaintenanceWindow;
    private Integer port;
    private String notificationTopicArn;
    private Boolean autoMinorVersionUpgrade;

    public CreateCacheClusterRequest() {
    }

    public CreateCacheClusterRequest(String cacheClusterId, Integer numCacheNodes, String cacheNodeType, String engine, List<String> cacheSecurityGroupNames) {
        this.setCacheClusterId(cacheClusterId);
        this.setNumCacheNodes(numCacheNodes);
        this.setCacheNodeType(cacheNodeType);
        this.setEngine(engine);
        this.setCacheSecurityGroupNames(cacheSecurityGroupNames);
    }

    public String getCacheClusterId() {
        return this.cacheClusterId;
    }

    public void setCacheClusterId(String cacheClusterId) {
        this.cacheClusterId = cacheClusterId;
    }

    public CreateCacheClusterRequest withCacheClusterId(String cacheClusterId) {
        this.cacheClusterId = cacheClusterId;
        return this;
    }

    public String getReplicationGroupId() {
        return this.replicationGroupId;
    }

    public void setReplicationGroupId(String replicationGroupId) {
        this.replicationGroupId = replicationGroupId;
    }

    public CreateCacheClusterRequest withReplicationGroupId(String replicationGroupId) {
        this.replicationGroupId = replicationGroupId;
        return this;
    }

    public Integer getNumCacheNodes() {
        return this.numCacheNodes;
    }

    public void setNumCacheNodes(Integer numCacheNodes) {
        this.numCacheNodes = numCacheNodes;
    }

    public CreateCacheClusterRequest withNumCacheNodes(Integer numCacheNodes) {
        this.numCacheNodes = numCacheNodes;
        return this;
    }

    public String getCacheNodeType() {
        return this.cacheNodeType;
    }

    public void setCacheNodeType(String cacheNodeType) {
        this.cacheNodeType = cacheNodeType;
    }

    public CreateCacheClusterRequest withCacheNodeType(String cacheNodeType) {
        this.cacheNodeType = cacheNodeType;
        return this;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public CreateCacheClusterRequest withEngine(String engine) {
        this.engine = engine;
        return this;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public CreateCacheClusterRequest withEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
        return this;
    }

    public String getCacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public void setCacheParameterGroupName(String cacheParameterGroupName) {
        this.cacheParameterGroupName = cacheParameterGroupName;
    }

    public CreateCacheClusterRequest withCacheParameterGroupName(String cacheParameterGroupName) {
        this.cacheParameterGroupName = cacheParameterGroupName;
        return this;
    }

    public String getCacheSubnetGroupName() {
        return this.cacheSubnetGroupName;
    }

    public void setCacheSubnetGroupName(String cacheSubnetGroupName) {
        this.cacheSubnetGroupName = cacheSubnetGroupName;
    }

    public CreateCacheClusterRequest withCacheSubnetGroupName(String cacheSubnetGroupName) {
        this.cacheSubnetGroupName = cacheSubnetGroupName;
        return this;
    }

    public List<String> getCacheSecurityGroupNames() {
        if (this.cacheSecurityGroupNames == null) {
            this.cacheSecurityGroupNames = new ListWithAutoConstructFlag();
            this.cacheSecurityGroupNames.setAutoConstruct(true);
        }
        return this.cacheSecurityGroupNames;
    }

    public void setCacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
        if (cacheSecurityGroupNames == null) {
            this.cacheSecurityGroupNames = null;
            return;
        }
        ListWithAutoConstructFlag cacheSecurityGroupNamesCopy = new ListWithAutoConstructFlag(cacheSecurityGroupNames.size());
        cacheSecurityGroupNamesCopy.addAll(cacheSecurityGroupNames);
        this.cacheSecurityGroupNames = cacheSecurityGroupNamesCopy;
    }

    public CreateCacheClusterRequest withCacheSecurityGroupNames(String ... cacheSecurityGroupNames) {
        if (this.getCacheSecurityGroupNames() == null) {
            this.setCacheSecurityGroupNames(new ArrayList<String>(cacheSecurityGroupNames.length));
        }
        for (String value : cacheSecurityGroupNames) {
            this.getCacheSecurityGroupNames().add(value);
        }
        return this;
    }

    public CreateCacheClusterRequest withCacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
        if (cacheSecurityGroupNames == null) {
            this.cacheSecurityGroupNames = null;
        } else {
            ListWithAutoConstructFlag cacheSecurityGroupNamesCopy = new ListWithAutoConstructFlag(cacheSecurityGroupNames.size());
            cacheSecurityGroupNamesCopy.addAll(cacheSecurityGroupNames);
            this.cacheSecurityGroupNames = cacheSecurityGroupNamesCopy;
        }
        return this;
    }

    public List<String> getSecurityGroupIds() {
        if (this.securityGroupIds == null) {
            this.securityGroupIds = new ListWithAutoConstructFlag();
            this.securityGroupIds.setAutoConstruct(true);
        }
        return this.securityGroupIds;
    }

    public void setSecurityGroupIds(Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
            return;
        }
        ListWithAutoConstructFlag securityGroupIdsCopy = new ListWithAutoConstructFlag(securityGroupIds.size());
        securityGroupIdsCopy.addAll(securityGroupIds);
        this.securityGroupIds = securityGroupIdsCopy;
    }

    public CreateCacheClusterRequest withSecurityGroupIds(String ... securityGroupIds) {
        if (this.getSecurityGroupIds() == null) {
            this.setSecurityGroupIds(new ArrayList<String>(securityGroupIds.length));
        }
        for (String value : securityGroupIds) {
            this.getSecurityGroupIds().add(value);
        }
        return this;
    }

    public CreateCacheClusterRequest withSecurityGroupIds(Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
        } else {
            ListWithAutoConstructFlag securityGroupIdsCopy = new ListWithAutoConstructFlag(securityGroupIds.size());
            securityGroupIdsCopy.addAll(securityGroupIds);
            this.securityGroupIds = securityGroupIdsCopy;
        }
        return this;
    }

    public List<String> getSnapshotArns() {
        if (this.snapshotArns == null) {
            this.snapshotArns = new ListWithAutoConstructFlag();
            this.snapshotArns.setAutoConstruct(true);
        }
        return this.snapshotArns;
    }

    public void setSnapshotArns(Collection<String> snapshotArns) {
        if (snapshotArns == null) {
            this.snapshotArns = null;
            return;
        }
        ListWithAutoConstructFlag snapshotArnsCopy = new ListWithAutoConstructFlag(snapshotArns.size());
        snapshotArnsCopy.addAll(snapshotArns);
        this.snapshotArns = snapshotArnsCopy;
    }

    public CreateCacheClusterRequest withSnapshotArns(String ... snapshotArns) {
        if (this.getSnapshotArns() == null) {
            this.setSnapshotArns(new ArrayList<String>(snapshotArns.length));
        }
        for (String value : snapshotArns) {
            this.getSnapshotArns().add(value);
        }
        return this;
    }

    public CreateCacheClusterRequest withSnapshotArns(Collection<String> snapshotArns) {
        if (snapshotArns == null) {
            this.snapshotArns = null;
        } else {
            ListWithAutoConstructFlag snapshotArnsCopy = new ListWithAutoConstructFlag(snapshotArns.size());
            snapshotArnsCopy.addAll(snapshotArns);
            this.snapshotArns = snapshotArnsCopy;
        }
        return this;
    }

    public String getPreferredAvailabilityZone() {
        return this.preferredAvailabilityZone;
    }

    public void setPreferredAvailabilityZone(String preferredAvailabilityZone) {
        this.preferredAvailabilityZone = preferredAvailabilityZone;
    }

    public CreateCacheClusterRequest withPreferredAvailabilityZone(String preferredAvailabilityZone) {
        this.preferredAvailabilityZone = preferredAvailabilityZone;
        return this;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public CreateCacheClusterRequest withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public CreateCacheClusterRequest withPort(Integer port) {
        this.port = port;
        return this;
    }

    public String getNotificationTopicArn() {
        return this.notificationTopicArn;
    }

    public void setNotificationTopicArn(String notificationTopicArn) {
        this.notificationTopicArn = notificationTopicArn;
    }

    public CreateCacheClusterRequest withNotificationTopicArn(String notificationTopicArn) {
        this.notificationTopicArn = notificationTopicArn;
        return this;
    }

    public Boolean isAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
    }

    public CreateCacheClusterRequest withAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        return this;
    }

    public Boolean getAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCacheClusterId() != null) {
            sb.append("CacheClusterId: " + this.getCacheClusterId() + ",");
        }
        if (this.getReplicationGroupId() != null) {
            sb.append("ReplicationGroupId: " + this.getReplicationGroupId() + ",");
        }
        if (this.getNumCacheNodes() != null) {
            sb.append("NumCacheNodes: " + this.getNumCacheNodes() + ",");
        }
        if (this.getCacheNodeType() != null) {
            sb.append("CacheNodeType: " + this.getCacheNodeType() + ",");
        }
        if (this.getEngine() != null) {
            sb.append("Engine: " + this.getEngine() + ",");
        }
        if (this.getEngineVersion() != null) {
            sb.append("EngineVersion: " + this.getEngineVersion() + ",");
        }
        if (this.getCacheParameterGroupName() != null) {
            sb.append("CacheParameterGroupName: " + this.getCacheParameterGroupName() + ",");
        }
        if (this.getCacheSubnetGroupName() != null) {
            sb.append("CacheSubnetGroupName: " + this.getCacheSubnetGroupName() + ",");
        }
        if (this.getCacheSecurityGroupNames() != null) {
            sb.append("CacheSecurityGroupNames: " + this.getCacheSecurityGroupNames() + ",");
        }
        if (this.getSecurityGroupIds() != null) {
            sb.append("SecurityGroupIds: " + this.getSecurityGroupIds() + ",");
        }
        if (this.getSnapshotArns() != null) {
            sb.append("SnapshotArns: " + this.getSnapshotArns() + ",");
        }
        if (this.getPreferredAvailabilityZone() != null) {
            sb.append("PreferredAvailabilityZone: " + this.getPreferredAvailabilityZone() + ",");
        }
        if (this.getPreferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: " + this.getPreferredMaintenanceWindow() + ",");
        }
        if (this.getPort() != null) {
            sb.append("Port: " + this.getPort() + ",");
        }
        if (this.getNotificationTopicArn() != null) {
            sb.append("NotificationTopicArn: " + this.getNotificationTopicArn() + ",");
        }
        if (this.isAutoMinorVersionUpgrade() != null) {
            sb.append("AutoMinorVersionUpgrade: " + this.isAutoMinorVersionUpgrade());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCacheClusterId() == null ? 0 : this.getCacheClusterId().hashCode());
        hashCode = 31 * hashCode + (this.getReplicationGroupId() == null ? 0 : this.getReplicationGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getNumCacheNodes() == null ? 0 : this.getNumCacheNodes().hashCode());
        hashCode = 31 * hashCode + (this.getCacheNodeType() == null ? 0 : this.getCacheNodeType().hashCode());
        hashCode = 31 * hashCode + (this.getEngine() == null ? 0 : this.getEngine().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getCacheParameterGroupName() == null ? 0 : this.getCacheParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getCacheSubnetGroupName() == null ? 0 : this.getCacheSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getCacheSecurityGroupNames() == null ? 0 : ((Object)this.getCacheSecurityGroupNames()).hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroupIds() == null ? 0 : ((Object)this.getSecurityGroupIds()).hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotArns() == null ? 0 : ((Object)this.getSnapshotArns()).hashCode());
        hashCode = 31 * hashCode + (this.getPreferredAvailabilityZone() == null ? 0 : this.getPreferredAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredMaintenanceWindow() == null ? 0 : this.getPreferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationTopicArn() == null ? 0 : this.getNotificationTopicArn().hashCode());
        hashCode = 31 * hashCode + (this.isAutoMinorVersionUpgrade() == null ? 0 : this.isAutoMinorVersionUpgrade().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCacheClusterRequest)) {
            return false;
        }
        CreateCacheClusterRequest other = (CreateCacheClusterRequest)obj;
        if (other.getCacheClusterId() == null ^ this.getCacheClusterId() == null) {
            return false;
        }
        if (other.getCacheClusterId() != null && !other.getCacheClusterId().equals(this.getCacheClusterId())) {
            return false;
        }
        if (other.getReplicationGroupId() == null ^ this.getReplicationGroupId() == null) {
            return false;
        }
        if (other.getReplicationGroupId() != null && !other.getReplicationGroupId().equals(this.getReplicationGroupId())) {
            return false;
        }
        if (other.getNumCacheNodes() == null ^ this.getNumCacheNodes() == null) {
            return false;
        }
        if (other.getNumCacheNodes() != null && !other.getNumCacheNodes().equals(this.getNumCacheNodes())) {
            return false;
        }
        if (other.getCacheNodeType() == null ^ this.getCacheNodeType() == null) {
            return false;
        }
        if (other.getCacheNodeType() != null && !other.getCacheNodeType().equals(this.getCacheNodeType())) {
            return false;
        }
        if (other.getEngine() == null ^ this.getEngine() == null) {
            return false;
        }
        if (other.getEngine() != null && !other.getEngine().equals(this.getEngine())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.getCacheParameterGroupName() == null ^ this.getCacheParameterGroupName() == null) {
            return false;
        }
        if (other.getCacheParameterGroupName() != null && !other.getCacheParameterGroupName().equals(this.getCacheParameterGroupName())) {
            return false;
        }
        if (other.getCacheSubnetGroupName() == null ^ this.getCacheSubnetGroupName() == null) {
            return false;
        }
        if (other.getCacheSubnetGroupName() != null && !other.getCacheSubnetGroupName().equals(this.getCacheSubnetGroupName())) {
            return false;
        }
        if (other.getCacheSecurityGroupNames() == null ^ this.getCacheSecurityGroupNames() == null) {
            return false;
        }
        if (other.getCacheSecurityGroupNames() != null && !((Object)other.getCacheSecurityGroupNames()).equals(this.getCacheSecurityGroupNames())) {
            return false;
        }
        if (other.getSecurityGroupIds() == null ^ this.getSecurityGroupIds() == null) {
            return false;
        }
        if (other.getSecurityGroupIds() != null && !((Object)other.getSecurityGroupIds()).equals(this.getSecurityGroupIds())) {
            return false;
        }
        if (other.getSnapshotArns() == null ^ this.getSnapshotArns() == null) {
            return false;
        }
        if (other.getSnapshotArns() != null && !((Object)other.getSnapshotArns()).equals(this.getSnapshotArns())) {
            return false;
        }
        if (other.getPreferredAvailabilityZone() == null ^ this.getPreferredAvailabilityZone() == null) {
            return false;
        }
        if (other.getPreferredAvailabilityZone() != null && !other.getPreferredAvailabilityZone().equals(this.getPreferredAvailabilityZone())) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() != null && !other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.getNotificationTopicArn() == null ^ this.getNotificationTopicArn() == null) {
            return false;
        }
        if (other.getNotificationTopicArn() != null && !other.getNotificationTopicArn().equals(this.getNotificationTopicArn())) {
            return false;
        }
        if (other.isAutoMinorVersionUpgrade() == null ^ this.isAutoMinorVersionUpgrade() == null) {
            return false;
        }
        return other.isAutoMinorVersionUpgrade() == null || other.isAutoMinorVersionUpgrade().equals(this.isAutoMinorVersionUpgrade());
    }
}

