/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeCacheClustersRequestMarshaller
implements Marshaller<Request<DescribeCacheClustersRequest>, DescribeCacheClustersRequest> {
    @Override
    public Request<DescribeCacheClustersRequest> marshall(DescribeCacheClustersRequest describeCacheClustersRequest) {
        if (describeCacheClustersRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeCacheClustersRequest> request = new DefaultRequest<DescribeCacheClustersRequest>(describeCacheClustersRequest, "AmazonElastiCache");
        request.addParameter("Action", "DescribeCacheClusters");
        request.addParameter("Version", "2013-06-15");
        if (describeCacheClustersRequest.getCacheClusterId() != null) {
            request.addParameter("CacheClusterId", StringUtils.fromString(describeCacheClustersRequest.getCacheClusterId()));
        }
        if (describeCacheClustersRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeCacheClustersRequest.getMaxRecords()));
        }
        if (describeCacheClustersRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeCacheClustersRequest.getMarker()));
        }
        if (describeCacheClustersRequest.isShowCacheNodeInfo() != null) {
            request.addParameter("ShowCacheNodeInfo", StringUtils.fromBoolean(describeCacheClustersRequest.isShowCacheNodeInfo()));
        }
        return request;
    }
}

