/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SolutionStackDescription
implements Serializable {
    private String solutionStackName;
    private ListWithAutoConstructFlag<String> permittedFileTypes;

    public String getSolutionStackName() {
        return this.solutionStackName;
    }

    public void setSolutionStackName(String solutionStackName) {
        this.solutionStackName = solutionStackName;
    }

    public SolutionStackDescription withSolutionStackName(String solutionStackName) {
        this.solutionStackName = solutionStackName;
        return this;
    }

    public List<String> getPermittedFileTypes() {
        if (this.permittedFileTypes == null) {
            this.permittedFileTypes = new ListWithAutoConstructFlag();
            this.permittedFileTypes.setAutoConstruct(true);
        }
        return this.permittedFileTypes;
    }

    public void setPermittedFileTypes(Collection<String> permittedFileTypes) {
        if (permittedFileTypes == null) {
            this.permittedFileTypes = null;
            return;
        }
        ListWithAutoConstructFlag permittedFileTypesCopy = new ListWithAutoConstructFlag(permittedFileTypes.size());
        permittedFileTypesCopy.addAll(permittedFileTypes);
        this.permittedFileTypes = permittedFileTypesCopy;
    }

    public SolutionStackDescription withPermittedFileTypes(String ... permittedFileTypes) {
        if (this.getPermittedFileTypes() == null) {
            this.setPermittedFileTypes(new ArrayList<String>(permittedFileTypes.length));
        }
        for (String value : permittedFileTypes) {
            this.getPermittedFileTypes().add(value);
        }
        return this;
    }

    public SolutionStackDescription withPermittedFileTypes(Collection<String> permittedFileTypes) {
        if (permittedFileTypes == null) {
            this.permittedFileTypes = null;
        } else {
            ListWithAutoConstructFlag permittedFileTypesCopy = new ListWithAutoConstructFlag(permittedFileTypes.size());
            permittedFileTypesCopy.addAll(permittedFileTypes);
            this.permittedFileTypes = permittedFileTypesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSolutionStackName() != null) {
            sb.append("SolutionStackName: " + this.getSolutionStackName() + ",");
        }
        if (this.getPermittedFileTypes() != null) {
            sb.append("PermittedFileTypes: " + this.getPermittedFileTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSolutionStackName() == null ? 0 : this.getSolutionStackName().hashCode());
        hashCode = 31 * hashCode + (this.getPermittedFileTypes() == null ? 0 : ((Object)this.getPermittedFileTypes()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SolutionStackDescription)) {
            return false;
        }
        SolutionStackDescription other = (SolutionStackDescription)obj;
        if (other.getSolutionStackName() == null ^ this.getSolutionStackName() == null) {
            return false;
        }
        if (other.getSolutionStackName() != null && !other.getSolutionStackName().equals(this.getSolutionStackName())) {
            return false;
        }
        if (other.getPermittedFileTypes() == null ^ this.getPermittedFileTypes() == null) {
            return false;
        }
        return other.getPermittedFileTypes() == null || ((Object)other.getPermittedFileTypes()).equals(this.getPermittedFileTypes());
    }
}

