/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentTier;
import com.amazonaws.services.elasticbeanstalk.model.OptionSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateEnvironmentRequestMarshaller
implements Marshaller<Request<CreateEnvironmentRequest>, CreateEnvironmentRequest> {
    @Override
    public Request<CreateEnvironmentRequest> marshall(CreateEnvironmentRequest createEnvironmentRequest) {
        EnvironmentTier environmentTierTier;
        if (createEnvironmentRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateEnvironmentRequest> request = new DefaultRequest<CreateEnvironmentRequest>(createEnvironmentRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "CreateEnvironment");
        request.addParameter("Version", "2010-12-01");
        if (createEnvironmentRequest.getApplicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString(createEnvironmentRequest.getApplicationName()));
        }
        if (createEnvironmentRequest.getEnvironmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString(createEnvironmentRequest.getEnvironmentName()));
        }
        if (createEnvironmentRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(createEnvironmentRequest.getDescription()));
        }
        if (createEnvironmentRequest.getCNAMEPrefix() != null) {
            request.addParameter("CNAMEPrefix", StringUtils.fromString(createEnvironmentRequest.getCNAMEPrefix()));
        }
        if ((environmentTierTier = createEnvironmentRequest.getTier()) != null) {
            if (environmentTierTier.getName() != null) {
                request.addParameter("Tier.Name", StringUtils.fromString(environmentTierTier.getName()));
            }
            if (environmentTierTier.getType() != null) {
                request.addParameter("Tier.Type", StringUtils.fromString(environmentTierTier.getType()));
            }
            if (environmentTierTier.getVersion() != null) {
                request.addParameter("Tier.Version", StringUtils.fromString(environmentTierTier.getVersion()));
            }
        }
        if (createEnvironmentRequest.getVersionLabel() != null) {
            request.addParameter("VersionLabel", StringUtils.fromString(createEnvironmentRequest.getVersionLabel()));
        }
        if (createEnvironmentRequest.getTemplateName() != null) {
            request.addParameter("TemplateName", StringUtils.fromString(createEnvironmentRequest.getTemplateName()));
        }
        if (createEnvironmentRequest.getSolutionStackName() != null) {
            request.addParameter("SolutionStackName", StringUtils.fromString(createEnvironmentRequest.getSolutionStackName()));
        }
        List<ConfigurationOptionSetting> optionSettingsList = createEnvironmentRequest.getOptionSettings();
        int optionSettingsListIndex = 1;
        for (ConfigurationOptionSetting optionSettingsListValue : optionSettingsList) {
            ConfigurationOptionSetting configurationOptionSettingMember = optionSettingsListValue;
            if (configurationOptionSettingMember != null) {
                if (configurationOptionSettingMember.getNamespace() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Namespace", StringUtils.fromString(configurationOptionSettingMember.getNamespace()));
                }
                if (configurationOptionSettingMember.getOptionName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".OptionName", StringUtils.fromString(configurationOptionSettingMember.getOptionName()));
                }
                if (configurationOptionSettingMember.getValue() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Value", StringUtils.fromString(configurationOptionSettingMember.getValue()));
                }
            }
            ++optionSettingsListIndex;
        }
        List<OptionSpecification> optionsToRemoveList = createEnvironmentRequest.getOptionsToRemove();
        int optionsToRemoveListIndex = 1;
        for (OptionSpecification optionsToRemoveListValue : optionsToRemoveList) {
            OptionSpecification optionSpecificationMember = optionsToRemoveListValue;
            if (optionSpecificationMember != null) {
                if (optionSpecificationMember.getNamespace() != null) {
                    request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex + ".Namespace", StringUtils.fromString(optionSpecificationMember.getNamespace()));
                }
                if (optionSpecificationMember.getOptionName() != null) {
                    request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex + ".OptionName", StringUtils.fromString(optionSpecificationMember.getOptionName()));
                }
            }
            ++optionsToRemoveListIndex;
        }
        return request;
    }
}

