/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroupModifyConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ModifyInstanceGroupsRequest
extends AmazonWebServiceRequest
implements Serializable {
    private ListWithAutoConstructFlag<InstanceGroupModifyConfig> instanceGroups;

    public ModifyInstanceGroupsRequest() {
    }

    public ModifyInstanceGroupsRequest(List<InstanceGroupModifyConfig> instanceGroups) {
        this.setInstanceGroups(instanceGroups);
    }

    public List<InstanceGroupModifyConfig> getInstanceGroups() {
        if (this.instanceGroups == null) {
            this.instanceGroups = new ListWithAutoConstructFlag();
            this.instanceGroups.setAutoConstruct(true);
        }
        return this.instanceGroups;
    }

    public void setInstanceGroups(Collection<InstanceGroupModifyConfig> instanceGroups) {
        if (instanceGroups == null) {
            this.instanceGroups = null;
            return;
        }
        ListWithAutoConstructFlag instanceGroupsCopy = new ListWithAutoConstructFlag(instanceGroups.size());
        instanceGroupsCopy.addAll(instanceGroups);
        this.instanceGroups = instanceGroupsCopy;
    }

    public ModifyInstanceGroupsRequest withInstanceGroups(InstanceGroupModifyConfig ... instanceGroups) {
        if (this.getInstanceGroups() == null) {
            this.setInstanceGroups(new ArrayList<InstanceGroupModifyConfig>(instanceGroups.length));
        }
        for (InstanceGroupModifyConfig value : instanceGroups) {
            this.getInstanceGroups().add(value);
        }
        return this;
    }

    public ModifyInstanceGroupsRequest withInstanceGroups(Collection<InstanceGroupModifyConfig> instanceGroups) {
        if (instanceGroups == null) {
            this.instanceGroups = null;
        } else {
            ListWithAutoConstructFlag instanceGroupsCopy = new ListWithAutoConstructFlag(instanceGroups.size());
            instanceGroupsCopy.addAll(instanceGroups);
            this.instanceGroups = instanceGroupsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceGroups() != null) {
            sb.append("InstanceGroups: " + this.getInstanceGroups());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceGroups() == null ? 0 : ((Object)this.getInstanceGroups()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceGroupsRequest)) {
            return false;
        }
        ModifyInstanceGroupsRequest other = (ModifyInstanceGroupsRequest)obj;
        if (other.getInstanceGroups() == null ^ this.getInstanceGroups() == null) {
            return false;
        }
        return other.getInstanceGroups() == null || ((Object)other.getInstanceGroups()).equals(this.getInstanceGroups());
    }
}

