/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RemoveTagsRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String resourceId;
    private ListWithAutoConstructFlag<String> tagKeys;

    public RemoveTagsRequest() {
    }

    public RemoveTagsRequest(String resourceId) {
        this.setResourceId(resourceId);
    }

    public RemoveTagsRequest(String resourceId, List<String> tagKeys) {
        this.setResourceId(resourceId);
        this.setTagKeys(tagKeys);
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public RemoveTagsRequest withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public List<String> getTagKeys() {
        if (this.tagKeys == null) {
            this.tagKeys = new ListWithAutoConstructFlag();
            this.tagKeys.setAutoConstruct(true);
        }
        return this.tagKeys;
    }

    public void setTagKeys(Collection<String> tagKeys) {
        if (tagKeys == null) {
            this.tagKeys = null;
            return;
        }
        ListWithAutoConstructFlag tagKeysCopy = new ListWithAutoConstructFlag(tagKeys.size());
        tagKeysCopy.addAll(tagKeys);
        this.tagKeys = tagKeysCopy;
    }

    public RemoveTagsRequest withTagKeys(String ... tagKeys) {
        if (this.getTagKeys() == null) {
            this.setTagKeys(new ArrayList<String>(tagKeys.length));
        }
        for (String value : tagKeys) {
            this.getTagKeys().add(value);
        }
        return this;
    }

    public RemoveTagsRequest withTagKeys(Collection<String> tagKeys) {
        if (tagKeys == null) {
            this.tagKeys = null;
        } else {
            ListWithAutoConstructFlag tagKeysCopy = new ListWithAutoConstructFlag(tagKeys.size());
            tagKeysCopy.addAll(tagKeys);
            this.tagKeys = tagKeysCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceId() != null) {
            sb.append("ResourceId: " + this.getResourceId() + ",");
        }
        if (this.getTagKeys() != null) {
            sb.append("TagKeys: " + this.getTagKeys());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceId() == null ? 0 : this.getResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getTagKeys() == null ? 0 : ((Object)this.getTagKeys()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveTagsRequest)) {
            return false;
        }
        RemoveTagsRequest other = (RemoveTagsRequest)obj;
        if (other.getResourceId() == null ^ this.getResourceId() == null) {
            return false;
        }
        if (other.getResourceId() != null && !other.getResourceId().equals(this.getResourceId())) {
            return false;
        }
        if (other.getTagKeys() == null ^ this.getTagKeys() == null) {
            return false;
        }
        return other.getTagKeys() == null || ((Object)other.getTagKeys()).equals(this.getTagKeys());
    }
}

