/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticmapreduce.model.ListStepsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class ListStepsRequestMarshaller
implements Marshaller<Request<ListStepsRequest>, ListStepsRequest> {
    @Override
    public Request<ListStepsRequest> marshall(ListStepsRequest listStepsRequest) {
        if (listStepsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListStepsRequest> request = new DefaultRequest<ListStepsRequest>(listStepsRequest, "AmazonElasticMapReduce");
        String target = "ElasticMapReduce.ListSteps";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.1");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            ListWithAutoConstructFlag stepStatesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (listStepsRequest.getClusterId() != null) {
                jsonWriter.key("ClusterId").value(listStepsRequest.getClusterId());
            }
            if (!((stepStatesList = (ListWithAutoConstructFlag)listStepsRequest.getStepStates()) == null || stepStatesList.isAutoConstruct() && stepStatesList.isEmpty())) {
                jsonWriter.key("StepStates");
                jsonWriter.array();
                for (String stepStatesListValue : stepStatesList) {
                    if (stepStatesListValue == null) continue;
                    jsonWriter.value(stepStatesListValue);
                }
                jsonWriter.endArray();
            }
            if (listStepsRequest.getMarker() != null) {
                jsonWriter.key("Marker").value(listStepsRequest.getMarker());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

