/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elastictranscoder.model.CreateJobOutput;
import com.amazonaws.services.elastictranscoder.model.CreateJobPlaylist;
import com.amazonaws.services.elastictranscoder.model.JobInput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateJobRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String pipelineId;
    private JobInput input;
    private CreateJobOutput output;
    private ListWithAutoConstructFlag<CreateJobOutput> outputs;
    private String outputKeyPrefix;
    private ListWithAutoConstructFlag<CreateJobPlaylist> playlists;

    public String getPipelineId() {
        return this.pipelineId;
    }

    public void setPipelineId(String pipelineId) {
        this.pipelineId = pipelineId;
    }

    public CreateJobRequest withPipelineId(String pipelineId) {
        this.pipelineId = pipelineId;
        return this;
    }

    public JobInput getInput() {
        return this.input;
    }

    public void setInput(JobInput input) {
        this.input = input;
    }

    public CreateJobRequest withInput(JobInput input) {
        this.input = input;
        return this;
    }

    public CreateJobOutput getOutput() {
        return this.output;
    }

    public void setOutput(CreateJobOutput output) {
        this.output = output;
    }

    public CreateJobRequest withOutput(CreateJobOutput output) {
        this.output = output;
        return this;
    }

    public List<CreateJobOutput> getOutputs() {
        if (this.outputs == null) {
            this.outputs = new ListWithAutoConstructFlag();
            this.outputs.setAutoConstruct(true);
        }
        return this.outputs;
    }

    public void setOutputs(Collection<CreateJobOutput> outputs) {
        if (outputs == null) {
            this.outputs = null;
            return;
        }
        ListWithAutoConstructFlag outputsCopy = new ListWithAutoConstructFlag(outputs.size());
        outputsCopy.addAll(outputs);
        this.outputs = outputsCopy;
    }

    public CreateJobRequest withOutputs(CreateJobOutput ... outputs) {
        if (this.getOutputs() == null) {
            this.setOutputs(new ArrayList<CreateJobOutput>(outputs.length));
        }
        for (CreateJobOutput value : outputs) {
            this.getOutputs().add(value);
        }
        return this;
    }

    public CreateJobRequest withOutputs(Collection<CreateJobOutput> outputs) {
        if (outputs == null) {
            this.outputs = null;
        } else {
            ListWithAutoConstructFlag outputsCopy = new ListWithAutoConstructFlag(outputs.size());
            outputsCopy.addAll(outputs);
            this.outputs = outputsCopy;
        }
        return this;
    }

    public String getOutputKeyPrefix() {
        return this.outputKeyPrefix;
    }

    public void setOutputKeyPrefix(String outputKeyPrefix) {
        this.outputKeyPrefix = outputKeyPrefix;
    }

    public CreateJobRequest withOutputKeyPrefix(String outputKeyPrefix) {
        this.outputKeyPrefix = outputKeyPrefix;
        return this;
    }

    public List<CreateJobPlaylist> getPlaylists() {
        if (this.playlists == null) {
            this.playlists = new ListWithAutoConstructFlag();
            this.playlists.setAutoConstruct(true);
        }
        return this.playlists;
    }

    public void setPlaylists(Collection<CreateJobPlaylist> playlists) {
        if (playlists == null) {
            this.playlists = null;
            return;
        }
        ListWithAutoConstructFlag playlistsCopy = new ListWithAutoConstructFlag(playlists.size());
        playlistsCopy.addAll(playlists);
        this.playlists = playlistsCopy;
    }

    public CreateJobRequest withPlaylists(CreateJobPlaylist ... playlists) {
        if (this.getPlaylists() == null) {
            this.setPlaylists(new ArrayList<CreateJobPlaylist>(playlists.length));
        }
        for (CreateJobPlaylist value : playlists) {
            this.getPlaylists().add(value);
        }
        return this;
    }

    public CreateJobRequest withPlaylists(Collection<CreateJobPlaylist> playlists) {
        if (playlists == null) {
            this.playlists = null;
        } else {
            ListWithAutoConstructFlag playlistsCopy = new ListWithAutoConstructFlag(playlists.size());
            playlistsCopy.addAll(playlists);
            this.playlists = playlistsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPipelineId() != null) {
            sb.append("PipelineId: " + this.getPipelineId() + ",");
        }
        if (this.getInput() != null) {
            sb.append("Input: " + this.getInput() + ",");
        }
        if (this.getOutput() != null) {
            sb.append("Output: " + this.getOutput() + ",");
        }
        if (this.getOutputs() != null) {
            sb.append("Outputs: " + this.getOutputs() + ",");
        }
        if (this.getOutputKeyPrefix() != null) {
            sb.append("OutputKeyPrefix: " + this.getOutputKeyPrefix() + ",");
        }
        if (this.getPlaylists() != null) {
            sb.append("Playlists: " + this.getPlaylists());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPipelineId() == null ? 0 : this.getPipelineId().hashCode());
        hashCode = 31 * hashCode + (this.getInput() == null ? 0 : this.getInput().hashCode());
        hashCode = 31 * hashCode + (this.getOutput() == null ? 0 : this.getOutput().hashCode());
        hashCode = 31 * hashCode + (this.getOutputs() == null ? 0 : ((Object)this.getOutputs()).hashCode());
        hashCode = 31 * hashCode + (this.getOutputKeyPrefix() == null ? 0 : this.getOutputKeyPrefix().hashCode());
        hashCode = 31 * hashCode + (this.getPlaylists() == null ? 0 : ((Object)this.getPlaylists()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobRequest)) {
            return false;
        }
        CreateJobRequest other = (CreateJobRequest)obj;
        if (other.getPipelineId() == null ^ this.getPipelineId() == null) {
            return false;
        }
        if (other.getPipelineId() != null && !other.getPipelineId().equals(this.getPipelineId())) {
            return false;
        }
        if (other.getInput() == null ^ this.getInput() == null) {
            return false;
        }
        if (other.getInput() != null && !other.getInput().equals(this.getInput())) {
            return false;
        }
        if (other.getOutput() == null ^ this.getOutput() == null) {
            return false;
        }
        if (other.getOutput() != null && !other.getOutput().equals(this.getOutput())) {
            return false;
        }
        if (other.getOutputs() == null ^ this.getOutputs() == null) {
            return false;
        }
        if (other.getOutputs() != null && !((Object)other.getOutputs()).equals(this.getOutputs())) {
            return false;
        }
        if (other.getOutputKeyPrefix() == null ^ this.getOutputKeyPrefix() == null) {
            return false;
        }
        if (other.getOutputKeyPrefix() != null && !other.getOutputKeyPrefix().equals(this.getOutputKeyPrefix())) {
            return false;
        }
        if (other.getPlaylists() == null ^ this.getPlaylists() == null) {
            return false;
        }
        return other.getPlaylists() == null || ((Object)other.getPlaylists()).equals(this.getPlaylists());
    }
}

