/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.glacier.model.CreateVaultRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class CreateVaultRequestMarshaller
implements Marshaller<Request<CreateVaultRequest>, CreateVaultRequest> {
    @Override
    public Request<CreateVaultRequest> marshall(CreateVaultRequest createVaultRequest) {
        if (createVaultRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateVaultRequest> request = new DefaultRequest<CreateVaultRequest>(createVaultRequest, "AmazonGlacier");
        String target = "Glacier.CreateVault";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}";
        uriResourcePath = uriResourcePath.replace("{accountId}", createVaultRequest.getAccountId() == null ? "" : StringUtils.fromString(createVaultRequest.getAccountId()));
        uriResourcePath = uriResourcePath.replace("{vaultName}", createVaultRequest.getVaultName() == null ? "" : StringUtils.fromString(createVaultRequest.getVaultName()));
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        return request;
    }
}

