/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.glacier.model.InitiateMultipartUploadRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class InitiateMultipartUploadRequestMarshaller
implements Marshaller<Request<InitiateMultipartUploadRequest>, InitiateMultipartUploadRequest> {
    @Override
    public Request<InitiateMultipartUploadRequest> marshall(InitiateMultipartUploadRequest initiateMultipartUploadRequest) {
        if (initiateMultipartUploadRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<InitiateMultipartUploadRequest> request = new DefaultRequest<InitiateMultipartUploadRequest>(initiateMultipartUploadRequest, "AmazonGlacier");
        String target = "Glacier.InitiateMultipartUpload";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        if (initiateMultipartUploadRequest.getArchiveDescription() != null) {
            request.addHeader("x-amz-archive-description", StringUtils.fromString(initiateMultipartUploadRequest.getArchiveDescription()));
        }
        if (initiateMultipartUploadRequest.getPartSize() != null) {
            request.addHeader("x-amz-part-size", StringUtils.fromString(initiateMultipartUploadRequest.getPartSize()));
        }
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/multipart-uploads";
        uriResourcePath = uriResourcePath.replace("{accountId}", initiateMultipartUploadRequest.getAccountId() == null ? "" : StringUtils.fromString(initiateMultipartUploadRequest.getAccountId()));
        uriResourcePath = uriResourcePath.replace("{vaultName}", initiateMultipartUploadRequest.getVaultName() == null ? "" : StringUtils.fromString(initiateMultipartUploadRequest.getVaultName()));
        if ((uriResourcePath = uriResourcePath.replaceAll("//", "/")).contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        return request;
    }
}

