/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.glacier.model.SetVaultNotificationsRequest;
import com.amazonaws.services.glacier.model.VaultNotificationConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class SetVaultNotificationsRequestMarshaller
implements Marshaller<Request<SetVaultNotificationsRequest>, SetVaultNotificationsRequest> {
    @Override
    public Request<SetVaultNotificationsRequest> marshall(SetVaultNotificationsRequest setVaultNotificationsRequest) {
        if (setVaultNotificationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SetVaultNotificationsRequest> request = new DefaultRequest<SetVaultNotificationsRequest>(setVaultNotificationsRequest, "AmazonGlacier");
        String target = "Glacier.SetVaultNotifications";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/notification-configuration";
        uriResourcePath = uriResourcePath.replace("{accountId}", setVaultNotificationsRequest.getAccountId() == null ? "" : StringUtils.fromString(setVaultNotificationsRequest.getAccountId()));
        uriResourcePath = uriResourcePath.replace("{vaultName}", setVaultNotificationsRequest.getVaultName() == null ? "" : StringUtils.fromString(setVaultNotificationsRequest.getVaultName()));
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            VaultNotificationConfig vaultNotificationConfig = setVaultNotificationsRequest.getVaultNotificationConfig();
            if (vaultNotificationConfig != null) {
                ListWithAutoConstructFlag eventsList;
                jsonWriter.object();
                if (vaultNotificationConfig.getSNSTopic() != null) {
                    jsonWriter.key("SNSTopic").value(vaultNotificationConfig.getSNSTopic());
                }
                if (!((eventsList = (ListWithAutoConstructFlag)vaultNotificationConfig.getEvents()) == null || eventsList.isAutoConstruct() && eventsList.isEmpty())) {
                    jsonWriter.key("Events");
                    jsonWriter.array();
                    for (String eventsListValue : eventsList) {
                        if (eventsListValue == null) continue;
                        jsonWriter.value(eventsListValue);
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

