/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.identitymanagement.model.InstanceProfile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListInstanceProfilesForRoleResult
implements Serializable {
    private ListWithAutoConstructFlag<InstanceProfile> instanceProfiles;
    private Boolean isTruncated;
    private String marker;

    public List<InstanceProfile> getInstanceProfiles() {
        if (this.instanceProfiles == null) {
            this.instanceProfiles = new ListWithAutoConstructFlag();
            this.instanceProfiles.setAutoConstruct(true);
        }
        return this.instanceProfiles;
    }

    public void setInstanceProfiles(Collection<InstanceProfile> instanceProfiles) {
        if (instanceProfiles == null) {
            this.instanceProfiles = null;
            return;
        }
        ListWithAutoConstructFlag instanceProfilesCopy = new ListWithAutoConstructFlag(instanceProfiles.size());
        instanceProfilesCopy.addAll(instanceProfiles);
        this.instanceProfiles = instanceProfilesCopy;
    }

    public ListInstanceProfilesForRoleResult withInstanceProfiles(InstanceProfile ... instanceProfiles) {
        if (this.getInstanceProfiles() == null) {
            this.setInstanceProfiles(new ArrayList<InstanceProfile>(instanceProfiles.length));
        }
        for (InstanceProfile value : instanceProfiles) {
            this.getInstanceProfiles().add(value);
        }
        return this;
    }

    public ListInstanceProfilesForRoleResult withInstanceProfiles(Collection<InstanceProfile> instanceProfiles) {
        if (instanceProfiles == null) {
            this.instanceProfiles = null;
        } else {
            ListWithAutoConstructFlag instanceProfilesCopy = new ListWithAutoConstructFlag(instanceProfiles.size());
            instanceProfilesCopy.addAll(instanceProfiles);
            this.instanceProfiles = instanceProfilesCopy;
        }
        return this;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public void setIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public ListInstanceProfilesForRoleResult withIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
        return this;
    }

    public Boolean getIsTruncated() {
        return this.isTruncated;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public ListInstanceProfilesForRoleResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceProfiles() != null) {
            sb.append("InstanceProfiles: " + this.getInstanceProfiles() + ",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: " + this.isTruncated() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceProfiles() == null ? 0 : ((Object)this.getInstanceProfiles()).hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstanceProfilesForRoleResult)) {
            return false;
        }
        ListInstanceProfilesForRoleResult other = (ListInstanceProfilesForRoleResult)obj;
        if (other.getInstanceProfiles() == null ^ this.getInstanceProfiles() == null) {
            return false;
        }
        if (other.getInstanceProfiles() != null && !((Object)other.getInstanceProfiles()).equals(this.getInstanceProfiles())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }
}

