/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.StreamStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StreamDescription
implements Serializable {
    private String streamName;
    private String streamARN;
    private String streamStatus;
    private ListWithAutoConstructFlag<Shard> shards;
    private Boolean hasMoreShards;

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public StreamDescription withStreamName(String streamName) {
        this.streamName = streamName;
        return this;
    }

    public String getStreamARN() {
        return this.streamARN;
    }

    public void setStreamARN(String streamARN) {
        this.streamARN = streamARN;
    }

    public StreamDescription withStreamARN(String streamARN) {
        this.streamARN = streamARN;
        return this;
    }

    public String getStreamStatus() {
        return this.streamStatus;
    }

    public void setStreamStatus(String streamStatus) {
        this.streamStatus = streamStatus;
    }

    public StreamDescription withStreamStatus(String streamStatus) {
        this.streamStatus = streamStatus;
        return this;
    }

    public void setStreamStatus(StreamStatus streamStatus) {
        this.streamStatus = streamStatus.toString();
    }

    public StreamDescription withStreamStatus(StreamStatus streamStatus) {
        this.streamStatus = streamStatus.toString();
        return this;
    }

    public List<Shard> getShards() {
        if (this.shards == null) {
            this.shards = new ListWithAutoConstructFlag();
            this.shards.setAutoConstruct(true);
        }
        return this.shards;
    }

    public void setShards(Collection<Shard> shards) {
        if (shards == null) {
            this.shards = null;
            return;
        }
        ListWithAutoConstructFlag shardsCopy = new ListWithAutoConstructFlag(shards.size());
        shardsCopy.addAll(shards);
        this.shards = shardsCopy;
    }

    public StreamDescription withShards(Shard ... shards) {
        if (this.getShards() == null) {
            this.setShards(new ArrayList<Shard>(shards.length));
        }
        for (Shard value : shards) {
            this.getShards().add(value);
        }
        return this;
    }

    public StreamDescription withShards(Collection<Shard> shards) {
        if (shards == null) {
            this.shards = null;
        } else {
            ListWithAutoConstructFlag shardsCopy = new ListWithAutoConstructFlag(shards.size());
            shardsCopy.addAll(shards);
            this.shards = shardsCopy;
        }
        return this;
    }

    public Boolean isHasMoreShards() {
        return this.hasMoreShards;
    }

    public void setHasMoreShards(Boolean hasMoreShards) {
        this.hasMoreShards = hasMoreShards;
    }

    public StreamDescription withHasMoreShards(Boolean hasMoreShards) {
        this.hasMoreShards = hasMoreShards;
        return this;
    }

    public Boolean getHasMoreShards() {
        return this.hasMoreShards;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStreamName() != null) {
            sb.append("StreamName: " + this.getStreamName() + ",");
        }
        if (this.getStreamARN() != null) {
            sb.append("StreamARN: " + this.getStreamARN() + ",");
        }
        if (this.getStreamStatus() != null) {
            sb.append("StreamStatus: " + this.getStreamStatus() + ",");
        }
        if (this.getShards() != null) {
            sb.append("Shards: " + this.getShards() + ",");
        }
        if (this.isHasMoreShards() != null) {
            sb.append("HasMoreShards: " + this.isHasMoreShards());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStreamName() == null ? 0 : this.getStreamName().hashCode());
        hashCode = 31 * hashCode + (this.getStreamARN() == null ? 0 : this.getStreamARN().hashCode());
        hashCode = 31 * hashCode + (this.getStreamStatus() == null ? 0 : this.getStreamStatus().hashCode());
        hashCode = 31 * hashCode + (this.getShards() == null ? 0 : ((Object)this.getShards()).hashCode());
        hashCode = 31 * hashCode + (this.isHasMoreShards() == null ? 0 : this.isHasMoreShards().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamDescription)) {
            return false;
        }
        StreamDescription other = (StreamDescription)obj;
        if (other.getStreamName() == null ^ this.getStreamName() == null) {
            return false;
        }
        if (other.getStreamName() != null && !other.getStreamName().equals(this.getStreamName())) {
            return false;
        }
        if (other.getStreamARN() == null ^ this.getStreamARN() == null) {
            return false;
        }
        if (other.getStreamARN() != null && !other.getStreamARN().equals(this.getStreamARN())) {
            return false;
        }
        if (other.getStreamStatus() == null ^ this.getStreamStatus() == null) {
            return false;
        }
        if (other.getStreamStatus() != null && !other.getStreamStatus().equals(this.getStreamStatus())) {
            return false;
        }
        if (other.getShards() == null ^ this.getShards() == null) {
            return false;
        }
        if (other.getShards() != null && !((Object)other.getShards()).equals(this.getShards())) {
            return false;
        }
        if (other.isHasMoreShards() == null ^ this.isHasMoreShards() == null) {
            return false;
        }
        return other.isHasMoreShards() == null || other.isHasMoreShards().equals(this.isHasMoreShards());
    }
}

