/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kinesis.model.MergeShardsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class MergeShardsRequestMarshaller
implements Marshaller<Request<MergeShardsRequest>, MergeShardsRequest> {
    @Override
    public Request<MergeShardsRequest> marshall(MergeShardsRequest mergeShardsRequest) {
        if (mergeShardsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<MergeShardsRequest> request = new DefaultRequest<MergeShardsRequest>(mergeShardsRequest, "AmazonKinesis");
        String target = "Kinesis_20131202.MergeShards";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.1");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (mergeShardsRequest.getStreamName() != null) {
                jsonWriter.key("StreamName").value(mergeShardsRequest.getStreamName());
            }
            if (mergeShardsRequest.getShardToMerge() != null) {
                jsonWriter.key("ShardToMerge").value(mergeShardsRequest.getShardToMerge());
            }
            if (mergeShardsRequest.getAdjacentShardToMerge() != null) {
                jsonWriter.key("AdjacentShardToMerge").value(mergeShardsRequest.getAdjacentShardToMerge());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

