/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeCommandsRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String deploymentId;
    private String instanceId;
    private ListWithAutoConstructFlag<String> commandIds;

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public DescribeCommandsRequest withDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
        return this;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public DescribeCommandsRequest withInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public List<String> getCommandIds() {
        if (this.commandIds == null) {
            this.commandIds = new ListWithAutoConstructFlag();
            this.commandIds.setAutoConstruct(true);
        }
        return this.commandIds;
    }

    public void setCommandIds(Collection<String> commandIds) {
        if (commandIds == null) {
            this.commandIds = null;
            return;
        }
        ListWithAutoConstructFlag commandIdsCopy = new ListWithAutoConstructFlag(commandIds.size());
        commandIdsCopy.addAll(commandIds);
        this.commandIds = commandIdsCopy;
    }

    public DescribeCommandsRequest withCommandIds(String ... commandIds) {
        if (this.getCommandIds() == null) {
            this.setCommandIds(new ArrayList<String>(commandIds.length));
        }
        for (String value : commandIds) {
            this.getCommandIds().add(value);
        }
        return this;
    }

    public DescribeCommandsRequest withCommandIds(Collection<String> commandIds) {
        if (commandIds == null) {
            this.commandIds = null;
        } else {
            ListWithAutoConstructFlag commandIdsCopy = new ListWithAutoConstructFlag(commandIds.size());
            commandIdsCopy.addAll(commandIds);
            this.commandIds = commandIdsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDeploymentId() != null) {
            sb.append("DeploymentId: " + this.getDeploymentId() + ",");
        }
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: " + this.getInstanceId() + ",");
        }
        if (this.getCommandIds() != null) {
            sb.append("CommandIds: " + this.getCommandIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDeploymentId() == null ? 0 : this.getDeploymentId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getCommandIds() == null ? 0 : ((Object)this.getCommandIds()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCommandsRequest)) {
            return false;
        }
        DescribeCommandsRequest other = (DescribeCommandsRequest)obj;
        if (other.getDeploymentId() == null ^ this.getDeploymentId() == null) {
            return false;
        }
        if (other.getDeploymentId() != null && !other.getDeploymentId().equals(this.getDeploymentId())) {
            return false;
        }
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getCommandIds() == null ^ this.getCommandIds() == null) {
            return false;
        }
        return other.getCommandIds() == null || ((Object)other.getCommandIds()).equals(this.getCommandIds());
    }
}

