/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.rds.model.EC2SecurityGroup;
import com.amazonaws.services.rds.model.IPRange;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DBSecurityGroup
implements Serializable {
    private String ownerId;
    private String dBSecurityGroupName;
    private String dBSecurityGroupDescription;
    private String vpcId;
    private ListWithAutoConstructFlag<EC2SecurityGroup> eC2SecurityGroups;
    private ListWithAutoConstructFlag<IPRange> iPRanges;

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public DBSecurityGroup withOwnerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public String getDBSecurityGroupName() {
        return this.dBSecurityGroupName;
    }

    public void setDBSecurityGroupName(String dBSecurityGroupName) {
        this.dBSecurityGroupName = dBSecurityGroupName;
    }

    public DBSecurityGroup withDBSecurityGroupName(String dBSecurityGroupName) {
        this.dBSecurityGroupName = dBSecurityGroupName;
        return this;
    }

    public String getDBSecurityGroupDescription() {
        return this.dBSecurityGroupDescription;
    }

    public void setDBSecurityGroupDescription(String dBSecurityGroupDescription) {
        this.dBSecurityGroupDescription = dBSecurityGroupDescription;
    }

    public DBSecurityGroup withDBSecurityGroupDescription(String dBSecurityGroupDescription) {
        this.dBSecurityGroupDescription = dBSecurityGroupDescription;
        return this;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public DBSecurityGroup withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    public List<EC2SecurityGroup> getEC2SecurityGroups() {
        if (this.eC2SecurityGroups == null) {
            this.eC2SecurityGroups = new ListWithAutoConstructFlag();
            this.eC2SecurityGroups.setAutoConstruct(true);
        }
        return this.eC2SecurityGroups;
    }

    public void setEC2SecurityGroups(Collection<EC2SecurityGroup> eC2SecurityGroups) {
        if (eC2SecurityGroups == null) {
            this.eC2SecurityGroups = null;
            return;
        }
        ListWithAutoConstructFlag eC2SecurityGroupsCopy = new ListWithAutoConstructFlag(eC2SecurityGroups.size());
        eC2SecurityGroupsCopy.addAll(eC2SecurityGroups);
        this.eC2SecurityGroups = eC2SecurityGroupsCopy;
    }

    public DBSecurityGroup withEC2SecurityGroups(EC2SecurityGroup ... eC2SecurityGroups) {
        if (this.getEC2SecurityGroups() == null) {
            this.setEC2SecurityGroups(new ArrayList<EC2SecurityGroup>(eC2SecurityGroups.length));
        }
        for (EC2SecurityGroup value : eC2SecurityGroups) {
            this.getEC2SecurityGroups().add(value);
        }
        return this;
    }

    public DBSecurityGroup withEC2SecurityGroups(Collection<EC2SecurityGroup> eC2SecurityGroups) {
        if (eC2SecurityGroups == null) {
            this.eC2SecurityGroups = null;
        } else {
            ListWithAutoConstructFlag eC2SecurityGroupsCopy = new ListWithAutoConstructFlag(eC2SecurityGroups.size());
            eC2SecurityGroupsCopy.addAll(eC2SecurityGroups);
            this.eC2SecurityGroups = eC2SecurityGroupsCopy;
        }
        return this;
    }

    public List<IPRange> getIPRanges() {
        if (this.iPRanges == null) {
            this.iPRanges = new ListWithAutoConstructFlag();
            this.iPRanges.setAutoConstruct(true);
        }
        return this.iPRanges;
    }

    public void setIPRanges(Collection<IPRange> iPRanges) {
        if (iPRanges == null) {
            this.iPRanges = null;
            return;
        }
        ListWithAutoConstructFlag iPRangesCopy = new ListWithAutoConstructFlag(iPRanges.size());
        iPRangesCopy.addAll(iPRanges);
        this.iPRanges = iPRangesCopy;
    }

    public DBSecurityGroup withIPRanges(IPRange ... iPRanges) {
        if (this.getIPRanges() == null) {
            this.setIPRanges(new ArrayList<IPRange>(iPRanges.length));
        }
        for (IPRange value : iPRanges) {
            this.getIPRanges().add(value);
        }
        return this;
    }

    public DBSecurityGroup withIPRanges(Collection<IPRange> iPRanges) {
        if (iPRanges == null) {
            this.iPRanges = null;
        } else {
            ListWithAutoConstructFlag iPRangesCopy = new ListWithAutoConstructFlag(iPRanges.size());
            iPRangesCopy.addAll(iPRanges);
            this.iPRanges = iPRangesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOwnerId() != null) {
            sb.append("OwnerId: " + this.getOwnerId() + ",");
        }
        if (this.getDBSecurityGroupName() != null) {
            sb.append("DBSecurityGroupName: " + this.getDBSecurityGroupName() + ",");
        }
        if (this.getDBSecurityGroupDescription() != null) {
            sb.append("DBSecurityGroupDescription: " + this.getDBSecurityGroupDescription() + ",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: " + this.getVpcId() + ",");
        }
        if (this.getEC2SecurityGroups() != null) {
            sb.append("EC2SecurityGroups: " + this.getEC2SecurityGroups() + ",");
        }
        if (this.getIPRanges() != null) {
            sb.append("IPRanges: " + this.getIPRanges());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOwnerId() == null ? 0 : this.getOwnerId().hashCode());
        hashCode = 31 * hashCode + (this.getDBSecurityGroupName() == null ? 0 : this.getDBSecurityGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getDBSecurityGroupDescription() == null ? 0 : this.getDBSecurityGroupDescription().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getEC2SecurityGroups() == null ? 0 : ((Object)this.getEC2SecurityGroups()).hashCode());
        hashCode = 31 * hashCode + (this.getIPRanges() == null ? 0 : ((Object)this.getIPRanges()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBSecurityGroup)) {
            return false;
        }
        DBSecurityGroup other = (DBSecurityGroup)obj;
        if (other.getOwnerId() == null ^ this.getOwnerId() == null) {
            return false;
        }
        if (other.getOwnerId() != null && !other.getOwnerId().equals(this.getOwnerId())) {
            return false;
        }
        if (other.getDBSecurityGroupName() == null ^ this.getDBSecurityGroupName() == null) {
            return false;
        }
        if (other.getDBSecurityGroupName() != null && !other.getDBSecurityGroupName().equals(this.getDBSecurityGroupName())) {
            return false;
        }
        if (other.getDBSecurityGroupDescription() == null ^ this.getDBSecurityGroupDescription() == null) {
            return false;
        }
        if (other.getDBSecurityGroupDescription() != null && !other.getDBSecurityGroupDescription().equals(this.getDBSecurityGroupDescription())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getEC2SecurityGroups() == null ^ this.getEC2SecurityGroups() == null) {
            return false;
        }
        if (other.getEC2SecurityGroups() != null && !((Object)other.getEC2SecurityGroups()).equals(this.getEC2SecurityGroups())) {
            return false;
        }
        if (other.getIPRanges() == null ^ this.getIPRanges() == null) {
            return false;
        }
        return other.getIPRanges() == null || ((Object)other.getIPRanges()).equals(this.getIPRanges());
    }
}

