/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EventCategoriesMap
implements Serializable {
    private String sourceType;
    private ListWithAutoConstructFlag<String> eventCategories;

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public EventCategoriesMap withSourceType(String sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    public List<String> getEventCategories() {
        if (this.eventCategories == null) {
            this.eventCategories = new ListWithAutoConstructFlag();
            this.eventCategories.setAutoConstruct(true);
        }
        return this.eventCategories;
    }

    public void setEventCategories(Collection<String> eventCategories) {
        if (eventCategories == null) {
            this.eventCategories = null;
            return;
        }
        ListWithAutoConstructFlag eventCategoriesCopy = new ListWithAutoConstructFlag(eventCategories.size());
        eventCategoriesCopy.addAll(eventCategories);
        this.eventCategories = eventCategoriesCopy;
    }

    public EventCategoriesMap withEventCategories(String ... eventCategories) {
        if (this.getEventCategories() == null) {
            this.setEventCategories(new ArrayList<String>(eventCategories.length));
        }
        for (String value : eventCategories) {
            this.getEventCategories().add(value);
        }
        return this;
    }

    public EventCategoriesMap withEventCategories(Collection<String> eventCategories) {
        if (eventCategories == null) {
            this.eventCategories = null;
        } else {
            ListWithAutoConstructFlag eventCategoriesCopy = new ListWithAutoConstructFlag(eventCategories.size());
            eventCategoriesCopy.addAll(eventCategories);
            this.eventCategories = eventCategoriesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceType() != null) {
            sb.append("SourceType: " + this.getSourceType() + ",");
        }
        if (this.getEventCategories() != null) {
            sb.append("EventCategories: " + this.getEventCategories());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceType() == null ? 0 : this.getSourceType().hashCode());
        hashCode = 31 * hashCode + (this.getEventCategories() == null ? 0 : ((Object)this.getEventCategories()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventCategoriesMap)) {
            return false;
        }
        EventCategoriesMap other = (EventCategoriesMap)obj;
        if (other.getSourceType() == null ^ this.getSourceType() == null) {
            return false;
        }
        if (other.getSourceType() != null && !other.getSourceType().equals(this.getSourceType())) {
            return false;
        }
        if (other.getEventCategories() == null ^ this.getEventCategories() == null) {
            return false;
        }
        return other.getEventCategories() == null || ((Object)other.getEventCategories()).equals(this.getEventCategories());
    }
}

