/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.rds.model.OptionSetting;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OptionConfiguration
implements Serializable {
    private String optionName;
    private Integer port;
    private ListWithAutoConstructFlag<String> dBSecurityGroupMemberships;
    private ListWithAutoConstructFlag<String> vpcSecurityGroupMemberships;
    private ListWithAutoConstructFlag<OptionSetting> optionSettings;

    public String getOptionName() {
        return this.optionName;
    }

    public void setOptionName(String optionName) {
        this.optionName = optionName;
    }

    public OptionConfiguration withOptionName(String optionName) {
        this.optionName = optionName;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public OptionConfiguration withPort(Integer port) {
        this.port = port;
        return this;
    }

    public List<String> getDBSecurityGroupMemberships() {
        if (this.dBSecurityGroupMemberships == null) {
            this.dBSecurityGroupMemberships = new ListWithAutoConstructFlag();
            this.dBSecurityGroupMemberships.setAutoConstruct(true);
        }
        return this.dBSecurityGroupMemberships;
    }

    public void setDBSecurityGroupMemberships(Collection<String> dBSecurityGroupMemberships) {
        if (dBSecurityGroupMemberships == null) {
            this.dBSecurityGroupMemberships = null;
            return;
        }
        ListWithAutoConstructFlag dBSecurityGroupMembershipsCopy = new ListWithAutoConstructFlag(dBSecurityGroupMemberships.size());
        dBSecurityGroupMembershipsCopy.addAll(dBSecurityGroupMemberships);
        this.dBSecurityGroupMemberships = dBSecurityGroupMembershipsCopy;
    }

    public OptionConfiguration withDBSecurityGroupMemberships(String ... dBSecurityGroupMemberships) {
        if (this.getDBSecurityGroupMemberships() == null) {
            this.setDBSecurityGroupMemberships(new ArrayList<String>(dBSecurityGroupMemberships.length));
        }
        for (String value : dBSecurityGroupMemberships) {
            this.getDBSecurityGroupMemberships().add(value);
        }
        return this;
    }

    public OptionConfiguration withDBSecurityGroupMemberships(Collection<String> dBSecurityGroupMemberships) {
        if (dBSecurityGroupMemberships == null) {
            this.dBSecurityGroupMemberships = null;
        } else {
            ListWithAutoConstructFlag dBSecurityGroupMembershipsCopy = new ListWithAutoConstructFlag(dBSecurityGroupMemberships.size());
            dBSecurityGroupMembershipsCopy.addAll(dBSecurityGroupMemberships);
            this.dBSecurityGroupMemberships = dBSecurityGroupMembershipsCopy;
        }
        return this;
    }

    public List<String> getVpcSecurityGroupMemberships() {
        if (this.vpcSecurityGroupMemberships == null) {
            this.vpcSecurityGroupMemberships = new ListWithAutoConstructFlag();
            this.vpcSecurityGroupMemberships.setAutoConstruct(true);
        }
        return this.vpcSecurityGroupMemberships;
    }

    public void setVpcSecurityGroupMemberships(Collection<String> vpcSecurityGroupMemberships) {
        if (vpcSecurityGroupMemberships == null) {
            this.vpcSecurityGroupMemberships = null;
            return;
        }
        ListWithAutoConstructFlag vpcSecurityGroupMembershipsCopy = new ListWithAutoConstructFlag(vpcSecurityGroupMemberships.size());
        vpcSecurityGroupMembershipsCopy.addAll(vpcSecurityGroupMemberships);
        this.vpcSecurityGroupMemberships = vpcSecurityGroupMembershipsCopy;
    }

    public OptionConfiguration withVpcSecurityGroupMemberships(String ... vpcSecurityGroupMemberships) {
        if (this.getVpcSecurityGroupMemberships() == null) {
            this.setVpcSecurityGroupMemberships(new ArrayList<String>(vpcSecurityGroupMemberships.length));
        }
        for (String value : vpcSecurityGroupMemberships) {
            this.getVpcSecurityGroupMemberships().add(value);
        }
        return this;
    }

    public OptionConfiguration withVpcSecurityGroupMemberships(Collection<String> vpcSecurityGroupMemberships) {
        if (vpcSecurityGroupMemberships == null) {
            this.vpcSecurityGroupMemberships = null;
        } else {
            ListWithAutoConstructFlag vpcSecurityGroupMembershipsCopy = new ListWithAutoConstructFlag(vpcSecurityGroupMemberships.size());
            vpcSecurityGroupMembershipsCopy.addAll(vpcSecurityGroupMemberships);
            this.vpcSecurityGroupMemberships = vpcSecurityGroupMembershipsCopy;
        }
        return this;
    }

    public List<OptionSetting> getOptionSettings() {
        if (this.optionSettings == null) {
            this.optionSettings = new ListWithAutoConstructFlag();
            this.optionSettings.setAutoConstruct(true);
        }
        return this.optionSettings;
    }

    public void setOptionSettings(Collection<OptionSetting> optionSettings) {
        if (optionSettings == null) {
            this.optionSettings = null;
            return;
        }
        ListWithAutoConstructFlag optionSettingsCopy = new ListWithAutoConstructFlag(optionSettings.size());
        optionSettingsCopy.addAll(optionSettings);
        this.optionSettings = optionSettingsCopy;
    }

    public OptionConfiguration withOptionSettings(OptionSetting ... optionSettings) {
        if (this.getOptionSettings() == null) {
            this.setOptionSettings(new ArrayList<OptionSetting>(optionSettings.length));
        }
        for (OptionSetting value : optionSettings) {
            this.getOptionSettings().add(value);
        }
        return this;
    }

    public OptionConfiguration withOptionSettings(Collection<OptionSetting> optionSettings) {
        if (optionSettings == null) {
            this.optionSettings = null;
        } else {
            ListWithAutoConstructFlag optionSettingsCopy = new ListWithAutoConstructFlag(optionSettings.size());
            optionSettingsCopy.addAll(optionSettings);
            this.optionSettings = optionSettingsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOptionName() != null) {
            sb.append("OptionName: " + this.getOptionName() + ",");
        }
        if (this.getPort() != null) {
            sb.append("Port: " + this.getPort() + ",");
        }
        if (this.getDBSecurityGroupMemberships() != null) {
            sb.append("DBSecurityGroupMemberships: " + this.getDBSecurityGroupMemberships() + ",");
        }
        if (this.getVpcSecurityGroupMemberships() != null) {
            sb.append("VpcSecurityGroupMemberships: " + this.getVpcSecurityGroupMemberships() + ",");
        }
        if (this.getOptionSettings() != null) {
            sb.append("OptionSettings: " + this.getOptionSettings());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOptionName() == null ? 0 : this.getOptionName().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.getDBSecurityGroupMemberships() == null ? 0 : ((Object)this.getDBSecurityGroupMemberships()).hashCode());
        hashCode = 31 * hashCode + (this.getVpcSecurityGroupMemberships() == null ? 0 : ((Object)this.getVpcSecurityGroupMemberships()).hashCode());
        hashCode = 31 * hashCode + (this.getOptionSettings() == null ? 0 : ((Object)this.getOptionSettings()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionConfiguration)) {
            return false;
        }
        OptionConfiguration other = (OptionConfiguration)obj;
        if (other.getOptionName() == null ^ this.getOptionName() == null) {
            return false;
        }
        if (other.getOptionName() != null && !other.getOptionName().equals(this.getOptionName())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.getDBSecurityGroupMemberships() == null ^ this.getDBSecurityGroupMemberships() == null) {
            return false;
        }
        if (other.getDBSecurityGroupMemberships() != null && !((Object)other.getDBSecurityGroupMemberships()).equals(this.getDBSecurityGroupMemberships())) {
            return false;
        }
        if (other.getVpcSecurityGroupMemberships() == null ^ this.getVpcSecurityGroupMemberships() == null) {
            return false;
        }
        if (other.getVpcSecurityGroupMemberships() != null && !((Object)other.getVpcSecurityGroupMemberships()).equals(this.getVpcSecurityGroupMemberships())) {
            return false;
        }
        if (other.getOptionSettings() == null ^ this.getOptionSettings() == null) {
            return false;
        }
        return other.getOptionSettings() == null || ((Object)other.getOptionSettings()).equals(this.getOptionSettings());
    }
}

