/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.redshift.model.EC2SecurityGroup;
import com.amazonaws.services.redshift.model.IPRange;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ClusterSecurityGroup
implements Serializable {
    private String clusterSecurityGroupName;
    private String description;
    private ListWithAutoConstructFlag<EC2SecurityGroup> eC2SecurityGroups;
    private ListWithAutoConstructFlag<IPRange> iPRanges;

    public String getClusterSecurityGroupName() {
        return this.clusterSecurityGroupName;
    }

    public void setClusterSecurityGroupName(String clusterSecurityGroupName) {
        this.clusterSecurityGroupName = clusterSecurityGroupName;
    }

    public ClusterSecurityGroup withClusterSecurityGroupName(String clusterSecurityGroupName) {
        this.clusterSecurityGroupName = clusterSecurityGroupName;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ClusterSecurityGroup withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<EC2SecurityGroup> getEC2SecurityGroups() {
        if (this.eC2SecurityGroups == null) {
            this.eC2SecurityGroups = new ListWithAutoConstructFlag();
            this.eC2SecurityGroups.setAutoConstruct(true);
        }
        return this.eC2SecurityGroups;
    }

    public void setEC2SecurityGroups(Collection<EC2SecurityGroup> eC2SecurityGroups) {
        if (eC2SecurityGroups == null) {
            this.eC2SecurityGroups = null;
            return;
        }
        ListWithAutoConstructFlag eC2SecurityGroupsCopy = new ListWithAutoConstructFlag(eC2SecurityGroups.size());
        eC2SecurityGroupsCopy.addAll(eC2SecurityGroups);
        this.eC2SecurityGroups = eC2SecurityGroupsCopy;
    }

    public ClusterSecurityGroup withEC2SecurityGroups(EC2SecurityGroup ... eC2SecurityGroups) {
        if (this.getEC2SecurityGroups() == null) {
            this.setEC2SecurityGroups(new ArrayList<EC2SecurityGroup>(eC2SecurityGroups.length));
        }
        for (EC2SecurityGroup value : eC2SecurityGroups) {
            this.getEC2SecurityGroups().add(value);
        }
        return this;
    }

    public ClusterSecurityGroup withEC2SecurityGroups(Collection<EC2SecurityGroup> eC2SecurityGroups) {
        if (eC2SecurityGroups == null) {
            this.eC2SecurityGroups = null;
        } else {
            ListWithAutoConstructFlag eC2SecurityGroupsCopy = new ListWithAutoConstructFlag(eC2SecurityGroups.size());
            eC2SecurityGroupsCopy.addAll(eC2SecurityGroups);
            this.eC2SecurityGroups = eC2SecurityGroupsCopy;
        }
        return this;
    }

    public List<IPRange> getIPRanges() {
        if (this.iPRanges == null) {
            this.iPRanges = new ListWithAutoConstructFlag();
            this.iPRanges.setAutoConstruct(true);
        }
        return this.iPRanges;
    }

    public void setIPRanges(Collection<IPRange> iPRanges) {
        if (iPRanges == null) {
            this.iPRanges = null;
            return;
        }
        ListWithAutoConstructFlag iPRangesCopy = new ListWithAutoConstructFlag(iPRanges.size());
        iPRangesCopy.addAll(iPRanges);
        this.iPRanges = iPRangesCopy;
    }

    public ClusterSecurityGroup withIPRanges(IPRange ... iPRanges) {
        if (this.getIPRanges() == null) {
            this.setIPRanges(new ArrayList<IPRange>(iPRanges.length));
        }
        for (IPRange value : iPRanges) {
            this.getIPRanges().add(value);
        }
        return this;
    }

    public ClusterSecurityGroup withIPRanges(Collection<IPRange> iPRanges) {
        if (iPRanges == null) {
            this.iPRanges = null;
        } else {
            ListWithAutoConstructFlag iPRangesCopy = new ListWithAutoConstructFlag(iPRanges.size());
            iPRangesCopy.addAll(iPRanges);
            this.iPRanges = iPRangesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusterSecurityGroupName() != null) {
            sb.append("ClusterSecurityGroupName: " + this.getClusterSecurityGroupName() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getEC2SecurityGroups() != null) {
            sb.append("EC2SecurityGroups: " + this.getEC2SecurityGroups() + ",");
        }
        if (this.getIPRanges() != null) {
            sb.append("IPRanges: " + this.getIPRanges());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusterSecurityGroupName() == null ? 0 : this.getClusterSecurityGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getEC2SecurityGroups() == null ? 0 : ((Object)this.getEC2SecurityGroups()).hashCode());
        hashCode = 31 * hashCode + (this.getIPRanges() == null ? 0 : ((Object)this.getIPRanges()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterSecurityGroup)) {
            return false;
        }
        ClusterSecurityGroup other = (ClusterSecurityGroup)obj;
        if (other.getClusterSecurityGroupName() == null ^ this.getClusterSecurityGroupName() == null) {
            return false;
        }
        if (other.getClusterSecurityGroupName() != null && !other.getClusterSecurityGroupName().equals(this.getClusterSecurityGroupName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getEC2SecurityGroups() == null ^ this.getEC2SecurityGroups() == null) {
            return false;
        }
        if (other.getEC2SecurityGroups() != null && !((Object)other.getEC2SecurityGroups()).equals(this.getEC2SecurityGroups())) {
            return false;
        }
        if (other.getIPRanges() == null ^ this.getIPRanges() == null) {
            return false;
        }
        return other.getIPRanges() == null || ((Object)other.getIPRanges()).equals(this.getIPRanges());
    }
}

