/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.redshift.model.EventInfoMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EventCategoriesMap
implements Serializable {
    private String sourceType;
    private ListWithAutoConstructFlag<EventInfoMap> events;

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public EventCategoriesMap withSourceType(String sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    public List<EventInfoMap> getEvents() {
        if (this.events == null) {
            this.events = new ListWithAutoConstructFlag();
            this.events.setAutoConstruct(true);
        }
        return this.events;
    }

    public void setEvents(Collection<EventInfoMap> events) {
        if (events == null) {
            this.events = null;
            return;
        }
        ListWithAutoConstructFlag eventsCopy = new ListWithAutoConstructFlag(events.size());
        eventsCopy.addAll(events);
        this.events = eventsCopy;
    }

    public EventCategoriesMap withEvents(EventInfoMap ... events) {
        if (this.getEvents() == null) {
            this.setEvents(new ArrayList<EventInfoMap>(events.length));
        }
        for (EventInfoMap value : events) {
            this.getEvents().add(value);
        }
        return this;
    }

    public EventCategoriesMap withEvents(Collection<EventInfoMap> events) {
        if (events == null) {
            this.events = null;
        } else {
            ListWithAutoConstructFlag eventsCopy = new ListWithAutoConstructFlag(events.size());
            eventsCopy.addAll(events);
            this.events = eventsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceType() != null) {
            sb.append("SourceType: " + this.getSourceType() + ",");
        }
        if (this.getEvents() != null) {
            sb.append("Events: " + this.getEvents());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceType() == null ? 0 : this.getSourceType().hashCode());
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : ((Object)this.getEvents()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventCategoriesMap)) {
            return false;
        }
        EventCategoriesMap other = (EventCategoriesMap)obj;
        if (other.getSourceType() == null ^ this.getSourceType() == null) {
            return false;
        }
        if (other.getSourceType() != null && !other.getSourceType().equals(this.getSourceType())) {
            return false;
        }
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        return other.getEvents() == null || ((Object)other.getEvents()).equals(this.getEvents());
    }
}

