/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.route53.model.HealthCheck;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListHealthChecksResult
implements Serializable {
    private ListWithAutoConstructFlag<HealthCheck> healthChecks;
    private String marker;
    private Boolean isTruncated;
    private String nextMarker;
    private String maxItems;

    public List<HealthCheck> getHealthChecks() {
        if (this.healthChecks == null) {
            this.healthChecks = new ListWithAutoConstructFlag();
            this.healthChecks.setAutoConstruct(true);
        }
        return this.healthChecks;
    }

    public void setHealthChecks(Collection<HealthCheck> healthChecks) {
        if (healthChecks == null) {
            this.healthChecks = null;
            return;
        }
        ListWithAutoConstructFlag healthChecksCopy = new ListWithAutoConstructFlag(healthChecks.size());
        healthChecksCopy.addAll(healthChecks);
        this.healthChecks = healthChecksCopy;
    }

    public ListHealthChecksResult withHealthChecks(HealthCheck ... healthChecks) {
        if (this.getHealthChecks() == null) {
            this.setHealthChecks(new ArrayList<HealthCheck>(healthChecks.length));
        }
        for (HealthCheck value : healthChecks) {
            this.getHealthChecks().add(value);
        }
        return this;
    }

    public ListHealthChecksResult withHealthChecks(Collection<HealthCheck> healthChecks) {
        if (healthChecks == null) {
            this.healthChecks = null;
        } else {
            ListWithAutoConstructFlag healthChecksCopy = new ListWithAutoConstructFlag(healthChecks.size());
            healthChecksCopy.addAll(healthChecks);
            this.healthChecks = healthChecksCopy;
        }
        return this;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public ListHealthChecksResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public void setIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public ListHealthChecksResult withIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
        return this;
    }

    public Boolean getIsTruncated() {
        return this.isTruncated;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public ListHealthChecksResult withNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }

    public String getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(String maxItems) {
        this.maxItems = maxItems;
    }

    public ListHealthChecksResult withMaxItems(String maxItems) {
        this.maxItems = maxItems;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHealthChecks() != null) {
            sb.append("HealthChecks: " + this.getHealthChecks() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker() + ",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: " + this.isTruncated() + ",");
        }
        if (this.getNextMarker() != null) {
            sb.append("NextMarker: " + this.getNextMarker() + ",");
        }
        if (this.getMaxItems() != null) {
            sb.append("MaxItems: " + this.getMaxItems());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHealthChecks() == null ? 0 : ((Object)this.getHealthChecks()).hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        hashCode = 31 * hashCode + (this.getMaxItems() == null ? 0 : this.getMaxItems().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHealthChecksResult)) {
            return false;
        }
        ListHealthChecksResult other = (ListHealthChecksResult)obj;
        if (other.getHealthChecks() == null ^ this.getHealthChecks() == null) {
            return false;
        }
        if (other.getHealthChecks() != null && !((Object)other.getHealthChecks()).equals(this.getHealthChecks())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        if (other.getNextMarker() != null && !other.getNextMarker().equals(this.getNextMarker())) {
            return false;
        }
        if (other.getMaxItems() == null ^ this.getMaxItems() == null) {
            return false;
        }
        return other.getMaxItems() == null || other.getMaxItems().equals(this.getMaxItems());
    }
}

