/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.internal.crypto.ByteRangeCapturingInputStream;
import com.amazonaws.services.s3.internal.crypto.CipherFactory;
import com.amazonaws.services.s3.internal.crypto.EncryptedUploadContext;
import com.amazonaws.services.s3.internal.crypto.EncryptionInstruction;
import com.amazonaws.services.s3.internal.crypto.EncryptionUtils;
import com.amazonaws.services.s3.internal.crypto.JceEncryptionConstants;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazonaws.services.s3.model.CopyPartResult;
import com.amazonaws.services.s3.model.CryptoConfiguration;
import com.amazonaws.services.s3.model.CryptoStorageMode;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.StaticEncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.util.VersionInfoUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AmazonS3EncryptionClient
extends AmazonS3Client {
    private EncryptionMaterialsProvider encryptionMaterialsProvider;
    private CryptoConfiguration cryptoConfig;
    private static final String USER_AGENT = AmazonS3EncryptionClient.class.getName() + "/" + VersionInfoUtils.getVersion();
    private static Log log = LogFactory.getLog(AmazonS3EncryptionClient.class);
    private Map<String, EncryptedUploadContext> currentMultipartUploadSecretKeys = Collections.synchronizedMap(new HashMap());

    public AmazonS3EncryptionClient(EncryptionMaterials encryptionMaterials) {
        this(new StaticEncryptionMaterialsProvider(encryptionMaterials));
    }

    public AmazonS3EncryptionClient(EncryptionMaterialsProvider encryptionMaterialsProvider) {
        this((AWSCredentialsProvider)null, encryptionMaterialsProvider, new ClientConfiguration(), new CryptoConfiguration());
    }

    public AmazonS3EncryptionClient(EncryptionMaterials encryptionMaterials, CryptoConfiguration cryptoConfig) {
        this(new StaticEncryptionMaterialsProvider(encryptionMaterials), cryptoConfig);
    }

    public AmazonS3EncryptionClient(EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfig) {
        this((AWSCredentialsProvider)null, encryptionMaterialsProvider, new ClientConfiguration(), cryptoConfig);
    }

    public AmazonS3EncryptionClient(AWSCredentials credentials, EncryptionMaterials encryptionMaterials) {
        this(credentials, (EncryptionMaterialsProvider)new StaticEncryptionMaterialsProvider(encryptionMaterials));
    }

    public AmazonS3EncryptionClient(AWSCredentials credentials, EncryptionMaterialsProvider encryptionMaterialsProvider) {
        this(credentials, encryptionMaterialsProvider, new ClientConfiguration(), new CryptoConfiguration());
    }

    public AmazonS3EncryptionClient(AWSCredentialsProvider credentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider) {
        this(credentialsProvider, encryptionMaterialsProvider, new ClientConfiguration(), new CryptoConfiguration());
    }

    public AmazonS3EncryptionClient(AWSCredentials credentials, EncryptionMaterials encryptionMaterials, CryptoConfiguration cryptoConfig) {
        this(credentials, (EncryptionMaterialsProvider)new StaticEncryptionMaterialsProvider(encryptionMaterials), cryptoConfig);
    }

    public AmazonS3EncryptionClient(AWSCredentials credentials, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfig) {
        this(credentials, encryptionMaterialsProvider, new ClientConfiguration(), cryptoConfig);
    }

    public AmazonS3EncryptionClient(AWSCredentialsProvider credentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfig) {
        this(credentialsProvider, encryptionMaterialsProvider, new ClientConfiguration(), cryptoConfig);
    }

    public AmazonS3EncryptionClient(AWSCredentials credentials, EncryptionMaterials encryptionMaterials, ClientConfiguration clientConfig, CryptoConfiguration cryptoConfig) {
        this(credentials, (EncryptionMaterialsProvider)new StaticEncryptionMaterialsProvider(encryptionMaterials), clientConfig, cryptoConfig);
    }

    public AmazonS3EncryptionClient(AWSCredentials credentials, EncryptionMaterialsProvider encryptionMaterialsProvider, ClientConfiguration clientConfig, CryptoConfiguration cryptoConfig) {
        super(credentials, clientConfig);
        this.assertParameterNotNull(encryptionMaterialsProvider, "EncryptionMaterialsProvider parameter must not be null.");
        this.assertParameterNotNull(cryptoConfig, "CryptoConfiguration parameter must not be null.");
        this.encryptionMaterialsProvider = encryptionMaterialsProvider;
        this.cryptoConfig = cryptoConfig;
    }

    public AmazonS3EncryptionClient(AWSCredentialsProvider credentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, ClientConfiguration clientConfig, CryptoConfiguration cryptoConfig) {
        super(credentialsProvider, clientConfig);
        this.assertParameterNotNull(encryptionMaterialsProvider, "EncryptionMaterialsProvider parameter must not be null.");
        this.assertParameterNotNull(cryptoConfig, "CryptoConfiguration parameter must not be null.");
        this.encryptionMaterialsProvider = encryptionMaterialsProvider;
        this.cryptoConfig = cryptoConfig;
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest putObjectRequest) throws AmazonClientException, AmazonServiceException {
        this.appendUserAgent(putObjectRequest, USER_AGENT);
        if (this.cryptoConfig.getStorageMode() == CryptoStorageMode.InstructionFile) {
            return this.putObjectUsingInstructionFile(putObjectRequest);
        }
        return this.putObjectUsingMetadata(putObjectRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public S3Object getObject(GetObjectRequest getObjectRequest) throws AmazonClientException, AmazonServiceException {
        S3Object objectToBeReturned;
        long[] desiredRange;
        block17: {
            S3Object retrievedObject;
            this.appendUserAgent(getObjectRequest, USER_AGENT);
            desiredRange = getObjectRequest.getRange();
            long[] adjustedCryptoRange = EncryptionUtils.getAdjustedCryptoRange(desiredRange);
            if (adjustedCryptoRange != null) {
                getObjectRequest.setRange(adjustedCryptoRange[0], adjustedCryptoRange[1]);
            }
            if ((retrievedObject = super.getObject(getObjectRequest)) == null) {
                return null;
            }
            try {
                if (EncryptionUtils.isEncryptionInfoInMetadata(retrievedObject)) {
                    objectToBeReturned = this.decryptObjectUsingMetadata(retrievedObject);
                    break block17;
                }
                S3Object instructionFile = null;
                try {
                    instructionFile = this.getInstructionFile(getObjectRequest);
                    if (EncryptionUtils.isEncryptionInfoInInstructionFile(instructionFile)) {
                        objectToBeReturned = this.decryptObjectUsingInstructionFile(retrievedObject, instructionFile);
                    } else {
                        log.warn((Object)String.format("Unable to detect encryption information for object '%s' in bucket '%s'. Returning object without decryption.", retrievedObject.getKey(), retrievedObject.getBucketName()));
                        objectToBeReturned = retrievedObject;
                    }
                }
                finally {
                    if (instructionFile != null) {
                        try {
                            instructionFile.getObjectContent().close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
            catch (AmazonClientException ace) {
                try {
                    retrievedObject.getObjectContent().close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw ace;
            }
        }
        return EncryptionUtils.adjustOutputToDesiredRange(objectToBeReturned, desiredRange);
    }

    @Override
    public ObjectMetadata getObject(GetObjectRequest getObjectRequest, File destinationFile) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(destinationFile, "The destination file parameter must be specified when downloading an object directly to a file");
        S3Object s3Object = this.getObject(getObjectRequest);
        if (s3Object == null) {
            return null;
        }
        OutputStream outputStream = null;
        try {
            int bytesRead;
            outputStream = new BufferedOutputStream(new FileOutputStream(destinationFile));
            byte[] buffer = new byte[10240];
            while ((bytesRead = s3Object.getObjectContent().read(buffer)) > -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new AmazonClientException("Unable to store object contents to disk: " + e.getMessage(), e);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception e) {}
            try {
                s3Object.getObjectContent().close();
            }
            catch (Exception e) {}
        }
        return s3Object.getObjectMetadata();
    }

    @Override
    public void deleteObject(DeleteObjectRequest deleteObjectRequest) {
        this.appendUserAgent(deleteObjectRequest, USER_AGENT);
        super.deleteObject(deleteObjectRequest);
        DeleteObjectRequest instructionDeleteRequest = EncryptionUtils.createInstructionDeleteObjectRequest(deleteObjectRequest);
        super.deleteObject(instructionDeleteRequest);
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws AmazonClientException, AmazonServiceException {
        this.appendUserAgent(completeMultipartUploadRequest, USER_AGENT);
        String uploadId = completeMultipartUploadRequest.getUploadId();
        EncryptedUploadContext encryptedUploadContext = this.currentMultipartUploadSecretKeys.get(uploadId);
        if (!encryptedUploadContext.hasFinalPartBeenSeen()) {
            throw new AmazonClientException("Unable to complete an encrypted multipart upload without being told which part was the last.  Without knowing which part was the last, the encrypted data in Amazon S3 is incomplete and corrupt.");
        }
        CompleteMultipartUploadResult result = super.completeMultipartUpload(completeMultipartUploadRequest);
        if (this.cryptoConfig.getStorageMode() == CryptoStorageMode.InstructionFile) {
            Cipher symmetricCipher = EncryptionUtils.createSymmetricCipher(encryptedUploadContext.getEnvelopeEncryptionKey(), 1, this.cryptoConfig.getCryptoProvider(), encryptedUploadContext.getFirstInitializationVector());
            EncryptionMaterials encryptionMaterials = this.encryptionMaterialsProvider.getEncryptionMaterials();
            byte[] encryptedEnvelopeSymmetricKey = EncryptionUtils.getEncryptedSymmetricKey(encryptedUploadContext.getEnvelopeEncryptionKey(), encryptionMaterials, this.cryptoConfig.getCryptoProvider());
            EncryptionInstruction instruction = new EncryptionInstruction(encryptionMaterials.getMaterialsDescription(), encryptedEnvelopeSymmetricKey, encryptedUploadContext.getEnvelopeEncryptionKey(), symmetricCipher);
            super.putObject(EncryptionUtils.createInstructionPutRequest(encryptedUploadContext.getBucketName(), encryptedUploadContext.getKey(), instruction));
        }
        this.currentMultipartUploadSecretKeys.remove(uploadId);
        return result;
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws AmazonClientException, AmazonServiceException {
        this.appendUserAgent(initiateMultipartUploadRequest, USER_AGENT);
        SecretKey envelopeSymmetricKey = EncryptionUtils.generateOneTimeUseSymmetricKey();
        Cipher symmetricCipher = EncryptionUtils.createSymmetricCipher(envelopeSymmetricKey, 1, this.cryptoConfig.getCryptoProvider(), null);
        if (this.cryptoConfig.getStorageMode() == CryptoStorageMode.ObjectMetadata) {
            EncryptionMaterials encryptionMaterials = this.encryptionMaterialsProvider.getEncryptionMaterials();
            byte[] encryptedEnvelopeSymmetricKey = EncryptionUtils.getEncryptedSymmetricKey(envelopeSymmetricKey, encryptionMaterials, this.cryptoConfig.getCryptoProvider());
            ObjectMetadata metadata = EncryptionUtils.updateMetadataWithEncryptionInfo(initiateMultipartUploadRequest, encryptedEnvelopeSymmetricKey, symmetricCipher, encryptionMaterials.getMaterialsDescription());
            initiateMultipartUploadRequest.setObjectMetadata(metadata);
        }
        InitiateMultipartUploadResult result = super.initiateMultipartUpload(initiateMultipartUploadRequest);
        EncryptedUploadContext encryptedUploadContext = new EncryptedUploadContext(initiateMultipartUploadRequest.getBucketName(), initiateMultipartUploadRequest.getKey(), envelopeSymmetricKey);
        encryptedUploadContext.setNextInitializationVector(symmetricCipher.getIV());
        encryptedUploadContext.setFirstInitializationVector(symmetricCipher.getIV());
        this.currentMultipartUploadSecretKeys.put(result.getUploadId(), encryptedUploadContext);
        return result;
    }

    @Override
    public UploadPartResult uploadPart(UploadPartRequest uploadPartRequest) throws AmazonClientException, AmazonServiceException {
        boolean partSizeMultipleOfCipherBlockSize;
        this.appendUserAgent(uploadPartRequest, USER_AGENT);
        boolean isLastPart = uploadPartRequest.isLastPart();
        String uploadId = uploadPartRequest.getUploadId();
        boolean bl = partSizeMultipleOfCipherBlockSize = uploadPartRequest.getPartSize() % (long)JceEncryptionConstants.SYMMETRIC_CIPHER_BLOCK_SIZE == 0L;
        if (!isLastPart && !partSizeMultipleOfCipherBlockSize) {
            throw new AmazonClientException("Invalid part size: part sizes for encrypted multipart uploads must be multiples of the cipher block size (" + JceEncryptionConstants.SYMMETRIC_CIPHER_BLOCK_SIZE + ") with the exception of the last part.  " + "Otherwise encryption adds extra padding that will corrupt the final object.");
        }
        EncryptedUploadContext encryptedUploadContext = this.currentMultipartUploadSecretKeys.get(uploadId);
        if (encryptedUploadContext == null) {
            throw new AmazonClientException("No client-side information available on upload ID " + uploadId);
        }
        SecretKey envelopeSymmetricKey = encryptedUploadContext.getEnvelopeEncryptionKey();
        byte[] iv = encryptedUploadContext.getNextInitializationVector();
        CipherFactory cipherFactory = new CipherFactory(envelopeSymmetricKey, 1, iv, this.cryptoConfig.getCryptoProvider());
        ByteRangeCapturingInputStream encryptedInputStream = EncryptionUtils.getEncryptedInputStream(uploadPartRequest, cipherFactory);
        uploadPartRequest.setInputStream(encryptedInputStream);
        if (uploadPartRequest.isLastPart()) {
            long cryptoContentLength = EncryptionUtils.calculateCryptoContentLength(cipherFactory.createCipher(), uploadPartRequest);
            if (cryptoContentLength > 0L) {
                uploadPartRequest.setPartSize(cryptoContentLength);
            }
            if (encryptedUploadContext.hasFinalPartBeenSeen()) {
                throw new AmazonClientException("This part was specified as the last part in a multipart upload, but a previous part was already marked as the last part.  Only the last part of the upload should be marked as the last part, otherwise it will cause the encrypted data to be corrupted.");
            }
            encryptedUploadContext.setHasFinalPartBeenSeen(true);
        }
        uploadPartRequest.setFile(null);
        uploadPartRequest.setFileOffset(0L);
        UploadPartResult result = super.uploadPart(uploadPartRequest);
        encryptedUploadContext.setNextInitializationVector(encryptedInputStream.getBlock());
        return result;
    }

    @Override
    public CopyPartResult copyPart(CopyPartRequest copyPartRequest) {
        String uploadId = copyPartRequest.getUploadId();
        EncryptedUploadContext encryptedUploadContext = this.currentMultipartUploadSecretKeys.get(uploadId);
        if (!encryptedUploadContext.hasFinalPartBeenSeen()) {
            encryptedUploadContext.setHasFinalPartBeenSeen(true);
        }
        return super.copyPart(copyPartRequest);
    }

    private PutObjectResult putObjectUsingMetadata(PutObjectRequest putObjectRequest) throws AmazonClientException, AmazonServiceException {
        EncryptionInstruction instruction = EncryptionUtils.generateInstruction(this.encryptionMaterialsProvider, this.cryptoConfig.getCryptoProvider());
        PutObjectRequest encryptedObjectRequest = EncryptionUtils.encryptRequestUsingInstruction(putObjectRequest, instruction);
        EncryptionUtils.updateMetadataWithEncryptionInstruction(putObjectRequest, instruction);
        return super.putObject(encryptedObjectRequest);
    }

    private PutObjectResult putObjectUsingInstructionFile(PutObjectRequest putObjectRequest) throws AmazonClientException, AmazonServiceException {
        EncryptionInstruction instruction = EncryptionUtils.generateInstruction(this.encryptionMaterialsProvider, this.cryptoConfig.getCryptoProvider());
        PutObjectRequest encryptedObjectRequest = EncryptionUtils.encryptRequestUsingInstruction(putObjectRequest, instruction);
        PutObjectResult encryptedObjectResult = super.putObject(encryptedObjectRequest);
        PutObjectRequest instructionRequest = EncryptionUtils.createInstructionPutRequest(putObjectRequest, instruction);
        super.putObject(instructionRequest);
        return encryptedObjectResult;
    }

    private S3Object decryptObjectUsingMetadata(S3Object object) {
        EncryptionInstruction instruction = EncryptionUtils.buildInstructionFromObjectMetadata(object, this.encryptionMaterialsProvider, this.cryptoConfig.getCryptoProvider());
        return EncryptionUtils.decryptObjectUsingInstruction(object, instruction);
    }

    private S3Object decryptObjectUsingInstructionFile(S3Object object, S3Object instructionFile) {
        EncryptionInstruction instruction = EncryptionUtils.buildInstructionFromInstructionFile(instructionFile, this.encryptionMaterialsProvider, this.cryptoConfig.getCryptoProvider());
        return EncryptionUtils.decryptObjectUsingInstruction(object, instruction);
    }

    private S3Object getInstructionFile(GetObjectRequest getObjectRequest) {
        try {
            GetObjectRequest instructionFileRequest = EncryptionUtils.createInstructionGetRequest(getObjectRequest);
            return super.getObject(instructionFileRequest);
        }
        catch (AmazonServiceException e) {
            log.debug((Object)("Unable to retrieve instruction file : " + e.getMessage()));
            return null;
        }
    }

    public <X extends AmazonWebServiceRequest> X appendUserAgent(X request, String userAgent) {
        request.getRequestClientOptions().appendUserAgent(userAgent);
        return request;
    }
}

