/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.services.s3.internal.crypto.CipherFactory;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class EncryptionInstruction {
    private final Map<String, String> materialsDescription;
    private final byte[] encryptedSymmetricKey;
    private final SecretKey symmetricKey;
    private final Cipher symmetricCipher;
    private final CipherFactory symmetricCipherFactory;

    public EncryptionInstruction(Map<String, String> materialsDescription, byte[] encryptedSymmetricKey, SecretKey symmetricKey, Cipher symmetricCipher) {
        this.materialsDescription = materialsDescription;
        this.encryptedSymmetricKey = encryptedSymmetricKey;
        this.symmetricKey = symmetricKey;
        this.symmetricCipher = symmetricCipher;
        this.symmetricCipherFactory = null;
    }

    public EncryptionInstruction(Map<String, String> materialsDescription, byte[] encryptedSymmetricKey, SecretKey symmetricKey, CipherFactory symmetricCipherFactory) {
        this.materialsDescription = materialsDescription;
        this.encryptedSymmetricKey = encryptedSymmetricKey;
        this.symmetricKey = symmetricKey;
        this.symmetricCipherFactory = symmetricCipherFactory;
        this.symmetricCipher = symmetricCipherFactory.createCipher();
    }

    public CipherFactory getCipherFactory() {
        return this.symmetricCipherFactory;
    }

    public Map<String, String> getMaterialsDescription() {
        return this.materialsDescription;
    }

    public byte[] getEncryptedSymmetricKey() {
        return this.encryptedSymmetricKey;
    }

    public SecretKey getSymmetricKey() {
        return this.symmetricKey;
    }

    public Cipher getSymmetricCipher() {
        return this.symmetricCipher;
    }
}

