/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.simpleemail.model.VerificationStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class IdentityDkimAttributes
implements Serializable {
    private Boolean dkimEnabled;
    private String dkimVerificationStatus;
    private ListWithAutoConstructFlag<String> dkimTokens;

    public Boolean isDkimEnabled() {
        return this.dkimEnabled;
    }

    public void setDkimEnabled(Boolean dkimEnabled) {
        this.dkimEnabled = dkimEnabled;
    }

    public IdentityDkimAttributes withDkimEnabled(Boolean dkimEnabled) {
        this.dkimEnabled = dkimEnabled;
        return this;
    }

    public Boolean getDkimEnabled() {
        return this.dkimEnabled;
    }

    public String getDkimVerificationStatus() {
        return this.dkimVerificationStatus;
    }

    public void setDkimVerificationStatus(String dkimVerificationStatus) {
        this.dkimVerificationStatus = dkimVerificationStatus;
    }

    public IdentityDkimAttributes withDkimVerificationStatus(String dkimVerificationStatus) {
        this.dkimVerificationStatus = dkimVerificationStatus;
        return this;
    }

    public void setDkimVerificationStatus(VerificationStatus dkimVerificationStatus) {
        this.dkimVerificationStatus = dkimVerificationStatus.toString();
    }

    public IdentityDkimAttributes withDkimVerificationStatus(VerificationStatus dkimVerificationStatus) {
        this.dkimVerificationStatus = dkimVerificationStatus.toString();
        return this;
    }

    public List<String> getDkimTokens() {
        if (this.dkimTokens == null) {
            this.dkimTokens = new ListWithAutoConstructFlag();
            this.dkimTokens.setAutoConstruct(true);
        }
        return this.dkimTokens;
    }

    public void setDkimTokens(Collection<String> dkimTokens) {
        if (dkimTokens == null) {
            this.dkimTokens = null;
            return;
        }
        ListWithAutoConstructFlag dkimTokensCopy = new ListWithAutoConstructFlag(dkimTokens.size());
        dkimTokensCopy.addAll(dkimTokens);
        this.dkimTokens = dkimTokensCopy;
    }

    public IdentityDkimAttributes withDkimTokens(String ... dkimTokens) {
        if (this.getDkimTokens() == null) {
            this.setDkimTokens(new ArrayList<String>(dkimTokens.length));
        }
        for (String value : dkimTokens) {
            this.getDkimTokens().add(value);
        }
        return this;
    }

    public IdentityDkimAttributes withDkimTokens(Collection<String> dkimTokens) {
        if (dkimTokens == null) {
            this.dkimTokens = null;
        } else {
            ListWithAutoConstructFlag dkimTokensCopy = new ListWithAutoConstructFlag(dkimTokens.size());
            dkimTokensCopy.addAll(dkimTokens);
            this.dkimTokens = dkimTokensCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.isDkimEnabled() != null) {
            sb.append("DkimEnabled: " + this.isDkimEnabled() + ",");
        }
        if (this.getDkimVerificationStatus() != null) {
            sb.append("DkimVerificationStatus: " + this.getDkimVerificationStatus() + ",");
        }
        if (this.getDkimTokens() != null) {
            sb.append("DkimTokens: " + this.getDkimTokens());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.isDkimEnabled() == null ? 0 : this.isDkimEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getDkimVerificationStatus() == null ? 0 : this.getDkimVerificationStatus().hashCode());
        hashCode = 31 * hashCode + (this.getDkimTokens() == null ? 0 : ((Object)this.getDkimTokens()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityDkimAttributes)) {
            return false;
        }
        IdentityDkimAttributes other = (IdentityDkimAttributes)obj;
        if (other.isDkimEnabled() == null ^ this.isDkimEnabled() == null) {
            return false;
        }
        if (other.isDkimEnabled() != null && !other.isDkimEnabled().equals(this.isDkimEnabled())) {
            return false;
        }
        if (other.getDkimVerificationStatus() == null ^ this.getDkimVerificationStatus() == null) {
            return false;
        }
        if (other.getDkimVerificationStatus() != null && !other.getDkimVerificationStatus().equals(this.getDkimVerificationStatus())) {
            return false;
        }
        if (other.getDkimTokens() == null ^ this.getDkimTokens() == null) {
            return false;
        }
        return other.getDkimTokens() == null || ((Object)other.getDkimTokens()).equals(this.getDkimTokens());
    }
}

