/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.pojo;

import com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.amazonaws.services.simpleworkflow.flow.JsonDataConverter;
import com.amazonaws.services.simpleworkflow.flow.annotations.Activities;
import com.amazonaws.services.simpleworkflow.flow.annotations.Activity;
import com.amazonaws.services.simpleworkflow.flow.annotations.ActivityRegistrationOptions;
import com.amazonaws.services.simpleworkflow.flow.annotations.ManualActivityCompletion;
import com.amazonaws.services.simpleworkflow.flow.annotations.NullDataConverter;
import com.amazonaws.services.simpleworkflow.flow.annotations.SkipTypeRegistration;
import com.amazonaws.services.simpleworkflow.flow.generic.ActivityImplementation;
import com.amazonaws.services.simpleworkflow.flow.generic.ActivityImplementationFactory;
import com.amazonaws.services.simpleworkflow.flow.pojo.POJOActivityImplementation;
import com.amazonaws.services.simpleworkflow.flow.worker.ActivityTypeExecutionOptions;
import com.amazonaws.services.simpleworkflow.flow.worker.ActivityTypeRegistrationOptions;
import com.amazonaws.services.simpleworkflow.model.ActivityType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class POJOActivityImplementationFactory
extends ActivityImplementationFactory {
    private List<ActivityType> activityTypesToRegister = new ArrayList<ActivityType>();
    private Map<ActivityType, POJOActivityImplementation> implementationsMap = new HashMap<ActivityType, POJOActivityImplementation>();
    private DataConverter dataConverter = new JsonDataConverter();

    public POJOActivityImplementationFactory() {
    }

    public POJOActivityImplementationFactory(Iterable<Object> activityImplementationObjects) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException {
        this();
        this.addActivitiesImplementations(activityImplementationObjects, null);
    }

    public POJOActivityImplementationFactory(Iterable<Object> activityImplementationObjects, DataConverter dataConverter) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException {
        this();
        this.addActivitiesImplementations(activityImplementationObjects, dataConverter);
    }

    public DataConverter getDataConverter() {
        return this.dataConverter;
    }

    public void setDataConverter(DataConverter dataConverter) {
        if (dataConverter == null) {
            throw new IllegalArgumentException("null dataConverter");
        }
        this.dataConverter = dataConverter;
    }

    public void setActivitiesImplementations(Iterable<Object> activitiesImplementations) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException {
        this.addActivitiesImplementations(activitiesImplementations, null);
    }

    public Iterable<Object> getActivitiesImplementations() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (POJOActivityImplementation impl : this.implementationsMap.values()) {
            result.add(impl.getActivitiesImplementation());
        }
        return result;
    }

    public List<ActivityType> addActivitiesImplementations(Iterable<Object> activitiesImplementations) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException {
        return this.addActivitiesImplementations(activitiesImplementations, null);
    }

    public List<ActivityType> addActivitiesImplementations(Iterable<Object> activitiesImplementations, DataConverter dataConverter) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException {
        ArrayList<ActivityType> result = new ArrayList<ActivityType>();
        for (Object activityImplementationObject : activitiesImplementations) {
            result.addAll(this.addActivitiesImplementation(activityImplementationObject, dataConverter));
        }
        return result;
    }

    public List<ActivityType> addActivitiesImplementation(Object activitiesImplementation) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException {
        return this.addActivitiesImplementation(activitiesImplementation, null);
    }

    public List<ActivityType> addActivitiesImplementation(Object activitiesImplementation, DataConverter converter) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException {
        if (activitiesImplementation == null) {
            throw new IllegalArgumentException("activitiesImplementation is null.");
        }
        HashSet<ActivityType> result = new HashSet<ActivityType>();
        HashSet activitiesInterfaces = new HashSet();
        this.getImplementedInterfacesAnnotatedWithActivities(activitiesImplementation.getClass(), activitiesInterfaces);
        if (activitiesInterfaces.size() == 0) {
            throw new IllegalArgumentException("Activity implementation object does not implement any interface annotated with @Activities: " + activitiesImplementation.getClass());
        }
        for (Class clazz : activitiesInterfaces) {
            HashMap<String, Method> methods = new HashMap<String, Method>();
            ParentInterfaceOptions parentOptions = new ParentInterfaceOptions();
            this.addActivities(activitiesImplementation, clazz, methods, parentOptions, converter, result);
        }
        return new ArrayList<ActivityType>(result);
    }

    private void addActivities(Object implementation, Class<?> interfaze, Map<String, Method> methods, ParentInterfaceOptions parentOptions, DataConverter converter, Set<ActivityType> addedTypes) throws SecurityException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        Activities activitiesAnnotation = interfaze.getAnnotation(Activities.class);
        for (Class<?> parent : interfaze.getInterfaces()) {
            this.addActivities(implementation, parent, methods, parentOptions, converter, addedTypes);
        }
        if (activitiesAnnotation != null) {
            String interfaceName = interfaze.getSimpleName();
            if (!POJOActivityImplementationFactory.nullOrEmpty(activitiesAnnotation.activityNamePrefix())) {
                parentOptions.setPrefix(activitiesAnnotation.activityNamePrefix());
            }
            if (!POJOActivityImplementationFactory.nullOrEmpty(activitiesAnnotation.version())) {
                parentOptions.setVersion(activitiesAnnotation.version());
            }
            converter = converter == null ? this.createConverter(activitiesAnnotation.dataConverter()) : converter;
            ActivityRegistrationOptions interfaceRegistrationOptionsAnnotation = interfaze.getAnnotation(ActivityRegistrationOptions.class);
            SkipTypeRegistration interfaceSkipTypeRegistrationAnnotation = interfaze.getAnnotation(SkipTypeRegistration.class);
            if (interfaceRegistrationOptionsAnnotation != null) {
                if (interfaceSkipTypeRegistrationAnnotation != null) {
                    throw new IllegalArgumentException("@ActivityRegistrationOptions is not allowed for the interface annotated with @SkipTypeRegistration.");
                }
                parentOptions.setRegistrationOptions(interfaceRegistrationOptionsAnnotation);
            } else if (interfaceSkipTypeRegistrationAnnotation != null) {
                parentOptions.setSkipRegistration(true);
            }
            for (Method method : interfaze.getMethods()) {
                if (!method.getDeclaringClass().equals(interfaze)) continue;
                Activity activityAnnotation = method.getAnnotation(Activity.class);
                ActivityType activityType = POJOActivityImplementationFactory.getActivityType(interfaceName, method, activityAnnotation, parentOptions);
                ActivityRegistrationOptions registrationOptionsAnnotation = method.getAnnotation(ActivityRegistrationOptions.class);
                SkipTypeRegistration skipTypeRegistrationAnnotation = interfaze.getAnnotation(SkipTypeRegistration.class);
                ActivityTypeRegistrationOptions registrationOptions = null;
                if (skipTypeRegistrationAnnotation != null) {
                    if (registrationOptionsAnnotation != null) {
                        throw new IllegalArgumentException("@ActivityRegistrationOptions is not allowed for the method annotated with @SkipTypeRegistration: " + method);
                    }
                } else if (registrationOptionsAnnotation != null || parentOptions.getRegistrationOptions() != null) {
                    POJOActivityImplementation existingImplementation = this.implementationsMap.get(activityType);
                    if (existingImplementation != null && !addedTypes.contains(activityType)) {
                        String message = "Duplicate declaration for activity type=" + activityType.getName() + ", version=" + activityType.getVersion() + ": " + existingImplementation.getMethod() + " and " + method;
                        throw new IllegalArgumentException(message);
                    }
                    registrationOptions = POJOActivityImplementationFactory.createRegistrationOptions(registrationOptionsAnnotation, parentOptions.getRegistrationOptions());
                } else if (!parentOptions.isSkipRegistration()) {
                    throw new IllegalArgumentException("No @ActivityRegistationOptions found either on interface or method for " + method);
                }
                if (addedTypes.contains(activityType)) continue;
                Method activityImplementationMethod = implementation.getClass().getMethod(method.getName(), method.getParameterTypes());
                ActivityTypeExecutionOptions executionOptions = POJOActivityImplementationFactory.createExecutionOptions(activityType, activityImplementationMethod);
                POJOActivityImplementation activityImplementation = new POJOActivityImplementation(implementation, method, registrationOptions, executionOptions, converter);
                this.activityTypesToRegister.add(activityType);
                addedTypes.add(activityType);
                this.implementationsMap.put(activityType, activityImplementation);
            }
        }
    }

    @Override
    public Iterable<ActivityType> getActivityTypesToRegister() {
        return this.activityTypesToRegister;
    }

    @Override
    public ActivityImplementation getActivityImplementation(ActivityType activityType) {
        return this.implementationsMap.get(activityType);
    }

    private DataConverter createConverter(Class<? extends DataConverter> converterType) throws InstantiationException, IllegalAccessException {
        if (converterType == null || converterType.equals(NullDataConverter.class)) {
            return this.dataConverter == null ? new JsonDataConverter() : this.dataConverter;
        }
        return converterType.newInstance();
    }

    private static ActivityType getActivityType(String interfaceName, Method activity, Activity activityAnnotation, ParentInterfaceOptions parentOptions) {
        ActivityType activityType = new ActivityType();
        String activityName = null;
        String activityVersion = null;
        if (activityAnnotation != null) {
            if (!POJOActivityImplementationFactory.nullOrEmpty(activityAnnotation.name())) {
                activityName = activityAnnotation.name();
            }
            if (!POJOActivityImplementationFactory.nullOrEmpty(activityAnnotation.version())) {
                activityVersion = activityAnnotation.version();
            }
        }
        if (activityName == null) {
            activityName = !POJOActivityImplementationFactory.nullOrEmpty(parentOptions.getPrefix()) ? parentOptions.getPrefix() + activity.getName() : interfaceName + "." + activity.getName();
        }
        if (activityVersion == null) {
            if (!POJOActivityImplementationFactory.nullOrEmpty(parentOptions.getVersion())) {
                activityVersion = parentOptions.getVersion();
            } else {
                throw new IllegalArgumentException("No version found for activity defined by " + activity);
            }
        }
        activityType.setName(activityName);
        activityType.setVersion(activityVersion);
        return activityType;
    }

    private static boolean nullOrEmpty(String nameFromAnnotation) {
        return nameFromAnnotation == null || nameFromAnnotation.isEmpty();
    }

    private void getImplementedInterfacesAnnotatedWithActivities(Class<?> implementationType, Set<Class<?>> implementedInterfaces) {
        Class<?>[] interfaces;
        Class<?> superClass = implementationType.getSuperclass();
        if (superClass != null) {
            this.getImplementedInterfacesAnnotatedWithActivities(superClass, implementedInterfaces);
        }
        for (Class<?> i : interfaces = implementationType.getInterfaces()) {
            if (i.getAnnotation(Activities.class) != null && !implementedInterfaces.contains(i)) {
                boolean skipAdd = this.removeSuperInterfaces(i, implementedInterfaces);
                if (skipAdd) continue;
                implementedInterfaces.add(i);
                continue;
            }
            this.getImplementedInterfacesAnnotatedWithActivities(i, implementedInterfaces);
        }
    }

    private boolean removeSuperInterfaces(Class<?> interfaceToAdd, Set<Class<?>> implementedInterfaces) {
        boolean skipAdd = false;
        ArrayList interfacesToRemove = new ArrayList();
        for (Class<?> clazz : implementedInterfaces) {
            if (clazz.isAssignableFrom(interfaceToAdd)) {
                interfacesToRemove.add(clazz);
            }
            if (!interfaceToAdd.isAssignableFrom(clazz)) continue;
            skipAdd = true;
        }
        for (Class<Object> clazz : interfacesToRemove) {
            implementedInterfaces.remove(clazz);
        }
        return skipAdd;
    }

    private static ActivityTypeRegistrationOptions createRegistrationOptions(ActivityRegistrationOptions registrationOptions, ActivityRegistrationOptions parentRegistrationOptions) {
        String taskList;
        long taskStartToCloseTimeoutSeconds;
        long taskScheduleToStartTimeoutSeconds;
        long taskScheduleToCloseTimeoutSeconds;
        ActivityRegistrationOptions registrationOptionsAnnotation = registrationOptions != null ? registrationOptions : parentRegistrationOptions;
        ActivityTypeRegistrationOptions result = new ActivityTypeRegistrationOptions();
        result.setDescription(POJOActivityImplementationFactory.emptyStringToNull(registrationOptionsAnnotation.description()));
        long taskHeartbeatTimeoutSeconds = registrationOptionsAnnotation.defaultTaskHeartbeatTimeoutSeconds();
        if (taskHeartbeatTimeoutSeconds > -2L) {
            result.setDefaultTaskHeartbeatTimeoutSeconds(taskHeartbeatTimeoutSeconds);
        }
        if ((taskScheduleToCloseTimeoutSeconds = registrationOptionsAnnotation.defaultTaskScheduleToCloseTimeoutSeconds()) > -2L) {
            result.setDefaultTaskScheduleToCloseTimeoutSeconds(taskScheduleToCloseTimeoutSeconds);
        }
        if ((taskScheduleToStartTimeoutSeconds = registrationOptionsAnnotation.defaultTaskScheduleToStartTimeoutSeconds()) > -2L) {
            result.setDefaultTaskScheduleToStartTimeoutSeconds(taskScheduleToStartTimeoutSeconds);
        }
        if ((taskStartToCloseTimeoutSeconds = registrationOptionsAnnotation.defaultTaskStartToCloseTimeoutSeconds()) > -2L) {
            result.setDefaultTaskStartToCloseTimeoutSeconds(taskStartToCloseTimeoutSeconds);
        }
        if (!(taskList = registrationOptionsAnnotation.defaultTaskList()).equals("USE_WORKER_TASK_LIST")) {
            result.setDefaultTaskList(taskList);
        } else if (taskList.equals("NO_DEFAULT_TASK_LIST")) {
            result.setDefaultTaskList(null);
        }
        return result;
    }

    private static ActivityTypeExecutionOptions createExecutionOptions(ActivityType activityType, Method activityImplementation) {
        assert (activityType != null);
        ActivityTypeExecutionOptions executionOptions = new ActivityTypeExecutionOptions();
        if (activityImplementation != null) {
            ManualActivityCompletion manualCompletion = activityImplementation.getAnnotation(ManualActivityCompletion.class);
            executionOptions.setManualActivityCompletion(manualCompletion != null);
        }
        return executionOptions;
    }

    private static String emptyStringToNull(String value) {
        if (value.length() == 0) {
            return null;
        }
        return value;
    }

    private static class ParentInterfaceOptions {
        private String version;
        private String prefix;
        private ActivityRegistrationOptions registrationOptions;
        private boolean skipRegistration;

        private ParentInterfaceOptions() {
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public ActivityRegistrationOptions getRegistrationOptions() {
            return this.registrationOptions;
        }

        public void setRegistrationOptions(ActivityRegistrationOptions options) {
            if (options != null) {
                this.setSkipRegistration(false);
            }
            this.registrationOptions = options;
        }

        public boolean isSkipRegistration() {
            return this.skipRegistration;
        }

        public void setSkipRegistration(boolean skipRegistration) {
            if (skipRegistration) {
                this.registrationOptions = null;
            }
            this.skipRegistration = skipRegistration;
        }
    }
}

