/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.sqs.model.Message;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReceiveMessageResult
implements Serializable {
    private ListWithAutoConstructFlag<Message> messages;

    public List<Message> getMessages() {
        if (this.messages == null) {
            this.messages = new ListWithAutoConstructFlag();
            this.messages.setAutoConstruct(true);
        }
        return this.messages;
    }

    public void setMessages(Collection<Message> messages) {
        if (messages == null) {
            this.messages = null;
            return;
        }
        ListWithAutoConstructFlag messagesCopy = new ListWithAutoConstructFlag(messages.size());
        messagesCopy.addAll(messages);
        this.messages = messagesCopy;
    }

    public ReceiveMessageResult withMessages(Message ... messages) {
        if (this.getMessages() == null) {
            this.setMessages(new ArrayList<Message>(messages.length));
        }
        for (Message value : messages) {
            this.getMessages().add(value);
        }
        return this;
    }

    public ReceiveMessageResult withMessages(Collection<Message> messages) {
        if (messages == null) {
            this.messages = null;
        } else {
            ListWithAutoConstructFlag messagesCopy = new ListWithAutoConstructFlag(messages.size());
            messagesCopy.addAll(messages);
            this.messages = messagesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMessages() != null) {
            sb.append("Messages: " + this.getMessages());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMessages() == null ? 0 : ((Object)this.getMessages()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiveMessageResult)) {
            return false;
        }
        ReceiveMessageResult other = (ReceiveMessageResult)obj;
        if (other.getMessages() == null ^ this.getMessages() == null) {
            return false;
        }
        return other.getMessages() == null || ((Object)other.getMessages()).equals(this.getMessages());
    }
}

