/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.support.model.Communication;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RecentCaseCommunications
implements Serializable {
    private ListWithAutoConstructFlag<Communication> communications;
    private String nextToken;

    public List<Communication> getCommunications() {
        if (this.communications == null) {
            this.communications = new ListWithAutoConstructFlag();
            this.communications.setAutoConstruct(true);
        }
        return this.communications;
    }

    public void setCommunications(Collection<Communication> communications) {
        if (communications == null) {
            this.communications = null;
            return;
        }
        ListWithAutoConstructFlag communicationsCopy = new ListWithAutoConstructFlag(communications.size());
        communicationsCopy.addAll(communications);
        this.communications = communicationsCopy;
    }

    public RecentCaseCommunications withCommunications(Communication ... communications) {
        if (this.getCommunications() == null) {
            this.setCommunications(new ArrayList<Communication>(communications.length));
        }
        for (Communication value : communications) {
            this.getCommunications().add(value);
        }
        return this;
    }

    public RecentCaseCommunications withCommunications(Collection<Communication> communications) {
        if (communications == null) {
            this.communications = null;
        } else {
            ListWithAutoConstructFlag communicationsCopy = new ListWithAutoConstructFlag(communications.size());
            communicationsCopy.addAll(communications);
            this.communications = communicationsCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public RecentCaseCommunications withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCommunications() != null) {
            sb.append("Communications: " + this.getCommunications() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCommunications() == null ? 0 : ((Object)this.getCommunications()).hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecentCaseCommunications)) {
            return false;
        }
        RecentCaseCommunications other = (RecentCaseCommunications)obj;
        if (other.getCommunications() == null ^ this.getCommunications() == null) {
            return false;
        }
        if (other.getCommunications() != null && !((Object)other.getCommunications()).equals(this.getCommunications())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }
}

