/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.support.model.CreateCaseRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class CreateCaseRequestMarshaller
implements Marshaller<Request<CreateCaseRequest>, CreateCaseRequest> {
    @Override
    public Request<CreateCaseRequest> marshall(CreateCaseRequest createCaseRequest) {
        if (createCaseRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateCaseRequest> request = new DefaultRequest<CreateCaseRequest>(createCaseRequest, "AWSSupport");
        String target = "AWSSupport_20130415.CreateCase";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.1");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            ListWithAutoConstructFlag ccEmailAddressesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createCaseRequest.getSubject() != null) {
                jsonWriter.key("subject").value(createCaseRequest.getSubject());
            }
            if (createCaseRequest.getServiceCode() != null) {
                jsonWriter.key("serviceCode").value(createCaseRequest.getServiceCode());
            }
            if (createCaseRequest.getSeverityCode() != null) {
                jsonWriter.key("severityCode").value(createCaseRequest.getSeverityCode());
            }
            if (createCaseRequest.getCategoryCode() != null) {
                jsonWriter.key("categoryCode").value(createCaseRequest.getCategoryCode());
            }
            if (createCaseRequest.getCommunicationBody() != null) {
                jsonWriter.key("communicationBody").value(createCaseRequest.getCommunicationBody());
            }
            if (!((ccEmailAddressesList = (ListWithAutoConstructFlag)createCaseRequest.getCcEmailAddresses()) == null || ccEmailAddressesList.isAutoConstruct() && ccEmailAddressesList.isEmpty())) {
                jsonWriter.key("ccEmailAddresses");
                jsonWriter.array();
                for (String ccEmailAddressesListValue : ccEmailAddressesList) {
                    if (ccEmailAddressesListValue == null) continue;
                    jsonWriter.value(ccEmailAddressesListValue);
                }
                jsonWriter.endArray();
            }
            if (createCaseRequest.getLanguage() != null) {
                jsonWriter.key("language").value(createCaseRequest.getLanguage());
            }
            if (createCaseRequest.getIssueType() != null) {
                jsonWriter.key("issueType").value(createCaseRequest.getIssueType());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

