/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.EC2MetadataClient;
import com.amazonaws.util.json.JSONUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EC2MetadataUtils {
    private static final String EC2_METADATA_ROOT = "/latest/meta-data";
    private static final String EC2_USERDATA_ROOT = "/latest/user-data/";
    private static final int DEFAULT_QUERY_RETRIES = 3;
    private static final int MINIMUM_RETRY_WAIT_TIME_MILLISECONDS = 250;
    private static Map<String, String> cache = new HashMap<String, String>();
    private static EC2MetadataClient ec2MetadataClient = new EC2MetadataClient();
    private static final Log log = LogFactory.getLog(EC2MetadataUtils.class);

    public static String getAmiId() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/ami-id");
    }

    public static String getAmiLaunchIndex() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/ami-launch-index");
    }

    public static String getAmiManifestPath() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/ami-manifest-path");
    }

    public static List<String> getAncestorAmiIds() {
        return EC2MetadataUtils.getItems("/latest/meta-data/ancestor-ami-ids");
    }

    public static String getInstanceAction() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/instance-action");
    }

    public static String getInstanceId() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/instance-id");
    }

    public static String getInstanceType() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/instance-type");
    }

    public static String getLocalHostName() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/local-hostname");
    }

    public static String getMacAddress() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/mac");
    }

    public static String getPrivateIpAddress() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/local-ipv4");
    }

    public static String getAvailabilityZone() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/placement/availability-zone");
    }

    public static List<String> getProductCodes() {
        return EC2MetadataUtils.getItems("/latest/meta-data/product-codes");
    }

    public static String getPublicKey() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/public-keys/0/openssh-key");
    }

    public static String getRamdiskId() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/ramdisk-id");
    }

    public static String getReservationId() {
        return EC2MetadataUtils.fetchData("/latest/meta-data/reservation-id");
    }

    public static List<String> getSecurityGroups() {
        return EC2MetadataUtils.getItems("/latest/meta-data/security-groups");
    }

    public static IAMInfo getIAMInstanceProfileInfo() {
        IAMInfo info;
        String json = EC2MetadataUtils.getData("/latest/meta-data/iam/info");
        if (null == json) {
            return null;
        }
        try {
            info = JSONUtils.toObject(IAMInfo.class, json);
        }
        catch (Exception e) {
            info = null;
        }
        return info;
    }

    public static Map<String, IAMSecurityCredential> getIAMSecurityCredentials() {
        HashMap<String, IAMSecurityCredential> credentialsInfoMap = new HashMap<String, IAMSecurityCredential>();
        List<String> credentials = EC2MetadataUtils.getItems("/latest/meta-data/iam/security-credentials");
        if (null != credentials) {
            for (String credential : credentials) {
                String json = EC2MetadataUtils.getData("/latest/meta-data/iam/security-credentials/" + credential);
                try {
                    IAMSecurityCredential credentialInfo = JSONUtils.toObject(IAMSecurityCredential.class, json);
                    credentialsInfoMap.put(credential, credentialInfo);
                }
                catch (Exception e) {
                    log.warn((Object)("Unable to process the credential(" + credential + "). " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return credentialsInfoMap;
    }

    public static Map<String, String> getBlockDeviceMapping() {
        HashMap<String, String> blockDeviceMapping = new HashMap<String, String>();
        List<String> devices = EC2MetadataUtils.getItems("/latest/meta-data/block-device-mapping");
        for (String device : devices) {
            blockDeviceMapping.put(device, EC2MetadataUtils.getData("/latest/meta-data/block-device-mapping/" + device));
        }
        return blockDeviceMapping;
    }

    public static List<NetworkInterface> getNetworkInterfaces() {
        LinkedList<NetworkInterface> networkInterfaces = new LinkedList<NetworkInterface>();
        List<String> macs = EC2MetadataUtils.getItems("/latest/meta-data/network/interfaces/macs/");
        for (String mac : macs) {
            String key = mac.trim();
            if (key.endsWith("/")) {
                key = key.substring(0, key.length() - 1);
            }
            networkInterfaces.add(new NetworkInterface(key));
        }
        return networkInterfaces;
    }

    public static String getUserData() {
        return EC2MetadataUtils.getData(EC2_USERDATA_ROOT);
    }

    public static String getData(String path) {
        return EC2MetadataUtils.getData(path, 3);
    }

    public static String getData(String path, int tries) {
        List<String> items = EC2MetadataUtils.getItems(path, tries, true);
        if (null != items && items.size() > 0) {
            return items.get(0);
        }
        return null;
    }

    public static List<String> getItems(String path) {
        return EC2MetadataUtils.getItems(path, 3, false);
    }

    public static List<String> getItems(String path, int tries) {
        return EC2MetadataUtils.getItems(path, tries, false);
    }

    private static List<String> getItems(String path, int tries, boolean slurp) {
        if (tries == 0) {
            throw new AmazonClientException("Unable to contact EC2 metadata service.");
        }
        try {
            String response = ec2MetadataClient.readResource(path);
            List<String> items = slurp ? Collections.singletonList(response) : Arrays.asList(response.split("\n"));
            return items;
        }
        catch (AmazonClientException ace) {
            log.warn((Object)"Unable to retrieve the requested metadata.");
            return null;
        }
        catch (Exception e) {
            int pause = (int)(Math.pow(2.0, 3 - tries) * 250.0);
            try {
                Thread.sleep(pause < 250 ? 250L : (long)pause);
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
            }
            return EC2MetadataUtils.getItems(path, tries - 1, slurp);
        }
    }

    private static String fetchData(String path) {
        return EC2MetadataUtils.fetchData(path, false);
    }

    private static String fetchData(String path, boolean force) {
        try {
            if (force || !cache.containsKey(path)) {
                cache.put(path, EC2MetadataUtils.getData(path));
            }
            return cache.get(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static class NetworkInterface {
        private String path;
        private String mac;
        private List<String> availableKeys;
        private Map<String, String> data = new HashMap<String, String>();

        private NetworkInterface() {
        }

        public NetworkInterface(String macAddress) {
            this.mac = macAddress;
            this.path = "/network/interfaces/macs/" + this.mac + "/";
        }

        public String getMacAddress() {
            return this.mac;
        }

        public String getOwnerId() {
            return this.getData("owner-id");
        }

        public String getProfile() {
            return this.getData("profile");
        }

        public String getHostname() {
            return this.getData("local-hostname");
        }

        public List<String> getLocalIPv4s() {
            return this.getItems("local-ipv4s");
        }

        public String getPublicHostname() {
            return this.getData("public-hostname");
        }

        public List<String> getPublicIPv4s() {
            return this.getItems("public-ipv4s");
        }

        public List<String> getSecurityGroups() {
            return this.getItems("security-groups");
        }

        public List<String> getSecurityGroupIds() {
            return this.getItems("security-group-ids");
        }

        public String getSubnetIPv4CidrBlock() {
            return this.getData("subnet-ipv4-cidr-block");
        }

        public String getVpcId() {
            return this.getData("vpc-id");
        }

        public List<String> getIPv4Association(String publicIp) {
            return EC2MetadataUtils.getItems(EC2MetadataUtils.EC2_METADATA_ROOT + this.path + "ipv4-associations/" + publicIp);
        }

        private String getData(String key) {
            if (this.data.containsKey(key)) {
                return this.data.get(key);
            }
            if (null == this.availableKeys) {
                this.availableKeys = EC2MetadataUtils.getItems(EC2MetadataUtils.EC2_METADATA_ROOT + this.path);
            }
            if (this.availableKeys.contains(key)) {
                this.data.put(key, EC2MetadataUtils.getData(EC2MetadataUtils.EC2_METADATA_ROOT + this.path + key));
                return this.data.get(key);
            }
            return null;
        }

        private List<String> getItems(String key) {
            if (null == this.availableKeys) {
                this.availableKeys = EC2MetadataUtils.getItems(EC2MetadataUtils.EC2_METADATA_ROOT + this.path);
            }
            if (this.availableKeys.contains(key)) {
                return EC2MetadataUtils.getItems(EC2MetadataUtils.EC2_METADATA_ROOT + this.path + key);
            }
            return new LinkedList<String>();
        }
    }

    public static class IAMSecurityCredential {
        public String code;
        public String message;
        public String lastUpdated;
        public String type;
        public String accessKeyId;
        public String secretAcessKey;
        public String token;
        public String expiration;
    }

    public static class IAMInfo {
        public String code;
        public String message;
        public String lastUpdated;
        public String instanceProfileArn;
        public String instanceProfileId;
    }
}

