/*
 * Decompiled with CFR 0.152.
 */
package com.emc.vipr.transform.encryption;

import com.emc.vipr.transform.encryption.EncryptionInputFilter;
import com.emc.vipr.transform.encryption.EncryptionOutputStream;
import com.emc.vipr.transform.encryption.EncryptionOutputTransform;
import com.emc.vipr.transform.encryption.KeyUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class BasicEncryptionOutputTransform
extends EncryptionOutputTransform {
    byte[] iv;
    SecretKey k;
    private String masterEncryptionKeyFingerprint;
    private KeyPair masterKey;

    public BasicEncryptionOutputTransform(OutputStream streamToEncodeTo, Map<String, String> metadataToEncode, String masterEncryptionKeyFingerprint, KeyPair asymmetricKey, String encryptionTransform, int keySize, Provider provider) {
        super(streamToEncodeTo, metadataToEncode, "ENC:" + encryptionTransform, provider);
        this.masterEncryptionKeyFingerprint = masterEncryptionKeyFingerprint;
        this.masterKey = asymmetricKey;
        try {
            Cipher cipher = this.initCipher(encryptionTransform, keySize);
            MessageDigest sha1 = null;
            sha1 = provider != null ? MessageDigest.getInstance("SHA1", provider) : MessageDigest.getInstance("SHA1");
            this.pushStream = new EncryptionOutputStream(streamToEncodeTo, cipher, sha1);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Error initializing output transform: " + e.getMessage(), e);
        }
    }

    public BasicEncryptionOutputTransform(InputStream streamToEncode, Map<String, String> metadataToEncode, String masterEncryptionKeyFingerprint, KeyPair asymmetricKey, String encryptionTransform, int keySize, Provider provider) {
        super(streamToEncode, metadataToEncode, "ENC:" + encryptionTransform, provider);
        this.masterEncryptionKeyFingerprint = masterEncryptionKeyFingerprint;
        this.masterKey = asymmetricKey;
        try {
            Cipher cipher = this.initCipher(encryptionTransform, keySize);
            MessageDigest sha1 = null;
            sha1 = provider != null ? MessageDigest.getInstance("SHA1", provider) : MessageDigest.getInstance("SHA1");
            this.pullStream = new EncryptionInputFilter(streamToEncode, cipher, sha1);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Error initializing output transform: " + e.getMessage(), e);
        }
    }

    private Cipher initCipher(String encryptionTransform, int keySize) throws GeneralSecurityException {
        Cipher cipher = null;
        cipher = this.provider != null ? Cipher.getInstance(encryptionTransform, this.provider) : Cipher.getInstance(encryptionTransform);
        SecureRandom rand = this.provider != null ? SecureRandom.getInstance("SHA1PRNG", this.provider) : SecureRandom.getInstance("SHA1PRNG");
        String[] algParts = encryptionTransform.split("/");
        KeyGenerator keygen = null;
        keygen = this.provider != null ? KeyGenerator.getInstance(algParts[0], this.provider) : KeyGenerator.getInstance(algParts[0]);
        keygen.init(keySize, rand);
        this.k = keygen.generateKey();
        cipher.init(1, (Key)this.k, rand);
        this.iv = cipher.getIV();
        return cipher;
    }

    @Override
    public Map<String, String> getEncodedMetadata() {
        HashMap<String, String> encodedMetadata = new HashMap<String, String>();
        encodedMetadata.putAll(this.metadataToEncode);
        String encodedIv = KeyUtils.urlSafeEncodeBase64(this.iv);
        encodedMetadata.put("x-emc-iv", encodedIv);
        encodedMetadata.put("x-emc-enc-key-id", this.masterEncryptionKeyFingerprint);
        try {
            encodedMetadata.put("x-emc-enc-object-key", KeyUtils.encryptKey(this.k, this.provider, this.masterKey.getPublic()));
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Could not encrypt key: " + e, e);
        }
        switch (this.getStreamMode()) {
            case PULL: {
                EncryptionInputFilter is = (EncryptionInputFilter)this.pullStream;
                encodedMetadata.put("x-emc-enc-unencrypted-sha1", KeyUtils.toHexPadded(is.getDigest()));
                encodedMetadata.put("x-emc-enc-unencrypted-size", "" + is.getByteCount());
                break;
            }
            case PUSH: {
                EncryptionOutputStream os = (EncryptionOutputStream)this.pushStream;
                encodedMetadata.put("x-emc-enc-unencrypted-sha1", KeyUtils.toHexPadded(os.getDigest()));
                encodedMetadata.put("x-emc-enc-unencrypted-size", "" + os.getByteCount());
            }
        }
        encodedMetadata.put("x-emc-enc-metadata-signature", KeyUtils.signMetadata(encodedMetadata, (RSAPrivateKey)this.masterKey.getPrivate(), this.provider));
        return encodedMetadata;
    }
}

