/*
 * Decompiled with CFR 0.152.
 */
package com.emc.vipr.transform.encryption;

import com.emc.vipr.transform.TransformException;
import com.emc.vipr.transform.encryption.BasicEncryptionInputTransform;
import com.emc.vipr.transform.encryption.BasicEncryptionOutputTransform;
import com.emc.vipr.transform.encryption.DoesNotNeedRekeyException;
import com.emc.vipr.transform.encryption.EncryptionTransformFactory;
import com.emc.vipr.transform.encryption.KeyUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicEncryptionTransformFactory
extends EncryptionTransformFactory<BasicEncryptionOutputTransform, BasicEncryptionInputTransform> {
    Logger logger = LoggerFactory.getLogger(BasicEncryptionTransformFactory.class);
    public KeyPair masterEncryptionKey;
    private String masterEncryptionKeyFingerprint;
    private Map<String, KeyPair> masterDecryptionKeys = new HashMap<String, KeyPair>();

    public BasicEncryptionTransformFactory() throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
    }

    public BasicEncryptionTransformFactory(KeyPair masterEncryptionKey, Set<KeyPair> masterDecryptionKeys) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        this.setMasterEncryptionKey(masterEncryptionKey);
        if (masterDecryptionKeys != null) {
            for (KeyPair kp : masterDecryptionKeys) {
                this.addMasterDecryptionKey(kp);
            }
        }
    }

    public BasicEncryptionTransformFactory(KeyPair masterEncryptionKey, Set<KeyPair> masterDecryptionKeys, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        super("AES/CBC/PKCS5Padding", 128, provider);
        this.setMasterEncryptionKey(masterEncryptionKey);
        if (masterDecryptionKeys != null) {
            for (KeyPair kp : masterDecryptionKeys) {
                this.addMasterDecryptionKey(kp);
            }
        }
    }

    public void setMasterEncryptionKey(KeyPair pair) {
        if (!(pair.getPublic() instanceof RSAPublicKey)) {
            throw new IllegalArgumentException("Only RSA KeyPairs are allowed, not " + pair.getPublic().getAlgorithm());
        }
        this.checkKeyLength(pair);
        this.masterEncryptionKey = pair;
        try {
            this.masterEncryptionKeyFingerprint = KeyUtils.getRsaPublicKeyFingerprint((RSAPublicKey)pair.getPublic(), this.provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error adding master key", e);
        }
        this.addMasterDecryptionKey(pair);
    }

    public void addMasterDecryptionKey(KeyPair pair) {
        try {
            String fingerprint = KeyUtils.getRsaPublicKeyFingerprint((RSAPublicKey)pair.getPublic(), this.provider);
            this.masterDecryptionKeys.put(fingerprint, pair);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error adding master key", e);
        }
    }

    @Override
    public Map<String, String> rekey(Map<String, String> metadata) throws TransformException {
        String newKey;
        String oldKeyId = metadata.get("x-emc-enc-key-id");
        if (oldKeyId == null) {
            throw new TransformException("Metadata does not contain a master key ID");
        }
        if (oldKeyId.equals(this.masterEncryptionKeyFingerprint)) {
            this.logger.info("Object is already using the current master key");
            throw new DoesNotNeedRekeyException("Object is already using the current master key");
        }
        if (!this.masterDecryptionKeys.containsKey(oldKeyId)) {
            throw new TransformException("Master key with fingerprint " + oldKeyId + " not found");
        }
        KeyPair oldKey = this.masterDecryptionKeys.get(oldKeyId);
        String encodedKey = metadata.get("x-emc-enc-object-key");
        if (encodedKey == null) {
            throw new TransformException("Encrypted object key not found");
        }
        String algorithm = this.getEncryptionAlgorithm();
        SecretKey objectKey = KeyUtils.decryptKey(encodedKey, algorithm, this.provider, oldKey.getPrivate());
        try {
            newKey = KeyUtils.encryptKey(objectKey, this.provider, this.masterEncryptionKey.getPublic());
        }
        catch (GeneralSecurityException e) {
            throw new TransformException("Could not re-encrypt key: " + e, e);
        }
        HashMap<String, String> newMetadata = new HashMap<String, String>();
        newMetadata.putAll(metadata);
        newMetadata.remove("x-emc-enc-metadata-signature");
        newMetadata.put("x-emc-enc-object-key", newKey);
        newMetadata.put("x-emc-enc-key-id", this.masterEncryptionKeyFingerprint);
        String signature = KeyUtils.signMetadata(newMetadata, (RSAPrivateKey)this.masterEncryptionKey.getPrivate(), this.provider);
        newMetadata.put("x-emc-enc-metadata-signature", signature);
        return newMetadata;
    }

    @Override
    public BasicEncryptionOutputTransform getOutputTransform(OutputStream streamToEncodeTo, Map<String, String> metadataToEncode) throws IOException {
        return new BasicEncryptionOutputTransform(streamToEncodeTo, metadataToEncode, this.masterEncryptionKeyFingerprint, this.masterEncryptionKey, this.encryptionTransform, this.keySize, this.provider);
    }

    @Override
    public BasicEncryptionOutputTransform getOutputTransform(InputStream streamToEncode, Map<String, String> metadataToEncode) throws IOException, TransformException {
        return new BasicEncryptionOutputTransform(streamToEncode, metadataToEncode, this.masterEncryptionKeyFingerprint, this.masterEncryptionKey, this.encryptionTransform, this.keySize, this.provider);
    }

    @Override
    public BasicEncryptionInputTransform getInputTransform(String transformConfig, InputStream streamToDecode, Map<String, String> metadata) throws IOException, TransformException {
        String[] transformTuple = this.splitTransformConfig(transformConfig);
        if (transformTuple.length != 2) {
            throw new TransformException("Invalid transform configuration: " + transformConfig);
        }
        if (!"ENC".equals(transformTuple[0])) {
            throw new TransformException("Unsupported transform class: " + transformTuple[0]);
        }
        String masterKeyId = metadata.get("x-emc-enc-key-id");
        if (masterKeyId == null) {
            throw new TransformException("Could not decrypt object. No master key ID set on object.");
        }
        KeyPair masterKey = this.masterDecryptionKeys.get(masterKeyId);
        if (masterKey == null) {
            throw new TransformException("Could not decrypt object. No master key with ID " + masterKeyId + " found");
        }
        return new BasicEncryptionInputTransform(transformTuple[1], streamToDecode, metadata, masterKey, this.provider);
    }

    private void checkKeyLength(KeyPair pair) {
        int keySize = ((RSAPublicKey)pair.getPublic()).getModulus().bitLength();
        if (keySize < 1024) {
            throw new IllegalArgumentException("The minimum RSA key size supported is 1024 bits. Your key is " + keySize + " bits");
        }
        if (keySize == 1024) {
            this.logger.info("1024-bit RSA key detected. Support for 1024-bit RSA keys may soon be removed from the JDK. Please upgrade to a stronger key (e.g. 2048-bit).");
        }
    }
}

