/*
 * Decompiled with CFR 0.152.
 */
package com.emc.vipr.transform.encryption;

import com.emc.vipr.transform.TransformException;
import com.emc.vipr.transform.TransformFactory;
import com.emc.vipr.transform.encryption.DoesNotNeedRekeyException;
import com.emc.vipr.transform.encryption.EncryptionInputTransform;
import com.emc.vipr.transform.encryption.EncryptionOutputTransform;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public abstract class EncryptionTransformFactory<T extends EncryptionOutputTransform, U extends EncryptionInputTransform>
extends TransformFactory<T, U> {
    protected Provider provider;
    protected String encryptionTransform;
    protected int keySize;

    public EncryptionTransformFactory() throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        this("AES/CBC/PKCS5Padding", 128, null);
    }

    public EncryptionTransformFactory(String encryptionTransform, int keySize, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        this.setEncryptionSettings(encryptionTransform, keySize, provider);
        this.setPriority(500);
    }

    public void setEncryptionSettings(String transform, int keySize, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        if (provider != null) {
            Cipher.getInstance(transform, provider);
        } else {
            Cipher.getInstance(transform);
        }
        if (keySize > Cipher.getMaxAllowedKeyLength(transform)) {
            throw new InvalidKeyException("Key size of " + keySize + " bits is larger than the maximum allowed of " + Cipher.getMaxAllowedKeyLength(transform));
        }
        this.encryptionTransform = transform;
        this.keySize = keySize;
        if (provider != null) {
            this.provider = provider;
        }
    }

    public static int getMaxKeySize(String transform) throws NoSuchAlgorithmException {
        return Cipher.getMaxAllowedKeyLength(transform);
    }

    public abstract Map<String, String> rekey(Map<String, String> var1) throws TransformException, DoesNotNeedRekeyException;

    public void setCryptoProvider(Provider provider) {
        this.provider = provider;
    }

    @Override
    public String getTransformClass() {
        return "ENC";
    }

    protected String getEncryptionAlgorithm() {
        return this.encryptionTransform.split("/")[0];
    }
}

