/*
 * Decompiled with CFR 0.152.
 */
package com.emc.vipr.transform.util;

import com.emc.vipr.transform.util.CloseCallback;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CloseNotifyOutputStream
extends FilterOutputStream {
    private CloseCallback callback;
    private boolean closed;

    public CloseNotifyOutputStream(OutputStream out, CloseCallback callback) {
        super(out);
        this.callback = callback;
        this.closed = false;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        this.closed = true;
        if (this.callback != null) {
            this.callback.closed(this);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        this.out.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        this.out.write(b);
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        this.out.flush();
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        this.out.write(b);
    }

    public boolean isClosed() {
        return this.closed;
    }
}

