/*
 * Decompiled with CFR 0.152.
 */
package com.emc.vipr.transform.encryption;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyUtils {
    private static final Logger logger = LoggerFactory.getLogger(KeyUtils.class);

    public static String getRsaPublicKeyFingerprint(RSAPublicKey pubKey, Provider provider) throws NoSuchAlgorithmException {
        byte[] pubkeyEnc = KeyUtils.derEncodeRSAPublicKey(pubKey);
        MessageDigest sha1 = provider != null ? MessageDigest.getInstance("sha1", provider) : MessageDigest.getInstance("sha1");
        byte[] pubkeyDigest = sha1.digest(pubkeyEnc);
        return KeyUtils.toHexPadded(pubkeyDigest);
    }

    public static String toHexPadded(byte[] data) {
        BigInteger bi = new BigInteger(1, data);
        String s = bi.toString(16);
        while (s.length() < data.length * 2) {
            s = "0" + s;
        }
        return s;
    }

    public static byte[] derEncodeBigInteger(BigInteger value) {
        return KeyUtils.derEncodeValue((byte)2, value.toByteArray());
    }

    public static byte[] derEncodeValue(byte type, byte[] bytes) {
        if (bytes.length < 128) {
            byte[] der = new byte[bytes.length + 2];
            der[0] = type;
            der[1] = (byte)bytes.length;
            System.arraycopy(bytes, 0, der, 2, bytes.length);
            return der;
        }
        BigInteger bigLength = BigInteger.valueOf(bytes.length);
        byte[] lengthBytes = bigLength.toByteArray();
        byte[] der = new byte[bytes.length + lengthBytes.length + 2];
        der[0] = type;
        der[1] = (byte)(lengthBytes.length | 0x80);
        System.arraycopy(lengthBytes, 0, der, 2, lengthBytes.length);
        System.arraycopy(bytes, 0, der, 2 + lengthBytes.length, bytes.length);
        return der;
    }

    public static byte[] derEncodeRSAPublicKey(RSAPublicKey pubkey) {
        ArrayList<byte[]> sequence = new ArrayList<byte[]>();
        sequence.add(KeyUtils.derEncodeBigInteger(pubkey.getModulus()));
        sequence.add(KeyUtils.derEncodeBigInteger(pubkey.getPublicExponent()));
        return KeyUtils.derEncodeSequence(sequence);
    }

    public static byte[] derEncodeSequence(List<byte[]> objects) {
        int totalSize = 0;
        for (byte[] obj : objects) {
            totalSize += obj.length;
        }
        byte[] objectData = new byte[totalSize];
        int p = 0;
        for (byte[] obj : objects) {
            System.arraycopy(obj, 0, objectData, p, obj.length);
            p += obj.length;
        }
        return KeyUtils.derEncodeValue((byte)48, objectData);
    }

    public static KeyPair rsaKeyPairFromBase64(String publicKey, String privateKey) throws GeneralSecurityException {
        try {
            byte[] pubKeyBytes = Base64.decodeBase64((byte[])publicKey.getBytes("US-ASCII"));
            byte[] privKeyBytes = Base64.decodeBase64((byte[])privateKey.getBytes("US-ASCII"));
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(pubKeyBytes);
            PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(privKeyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey pubKey = keyFactory.generatePublic(pubKeySpec);
            PrivateKey privKey = keyFactory.generatePrivate(privKeySpec);
            return new KeyPair(pubKey, privKey);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not load key pair: " + e, e);
        }
    }

    public static SecretKey decryptKey(String encodedKey, String algorithm, Provider provider, PrivateKey privateKey) {
        try {
            Cipher cipher = null;
            cipher = provider != null ? Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding", provider) : Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            cipher.init(2, privateKey);
            byte[] keyData = KeyUtils.urlSafeDecodeBase64(encodedKey);
            byte[] decryptedKey = cipher.doFinal(keyData);
            return new SecretKeySpec(decryptedKey, algorithm);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Error decrypting object key: " + e, e);
        }
    }

    public static String encryptKey(SecretKey key, Provider provider, PublicKey publicKey) throws GeneralSecurityException {
        Cipher cipher = null;
        cipher = provider != null ? Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding", provider) : Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
        cipher.init(1, publicKey);
        byte[] encryptedKey = cipher.doFinal(key.getEncoded());
        return KeyUtils.urlSafeEncodeBase64(encryptedKey);
    }

    public static String urlSafeEncodeBase64(byte[] data) {
        String b64Data;
        try {
            b64Data = new String(Base64.encodeBase64((byte[])data), "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("US-ASCII encoding not supported", e);
        }
        b64Data = b64Data.replace('+', '-');
        b64Data = b64Data.replace('/', '_');
        return b64Data;
    }

    public static byte[] urlSafeDecodeBase64(String b64Data) {
        byte[] data;
        b64Data = b64Data.replace('-', '+');
        b64Data = b64Data.replace('_', '/');
        try {
            data = Base64.decodeBase64((byte[])b64Data.getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("US-ASCII encoding not supported", e);
        }
        return data;
    }

    public static String signMetadata(Map<String, String> metadata, RSAPrivateKey privateKey, Provider provider) {
        byte[] bytes;
        ArrayList<String> keys = new ArrayList<String>();
        for (String key : metadata.keySet()) {
            if (!key.startsWith("x-emc-")) continue;
            keys.add(key);
        }
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                if (s1 == null && s2 == null) {
                    return 0;
                }
                if (s1 == null) {
                    return -s2.toLowerCase().compareTo(s1);
                }
                return s1.toLowerCase().compareTo(s2.toLowerCase());
            }
        });
        StringBuffer canonicalString = new StringBuffer();
        for (String key : keys) {
            canonicalString.append(key.toLowerCase() + ":" + metadata.get(key) + "\n");
        }
        logger.debug("Canonical string: '%s'", (Object)canonicalString);
        try {
            bytes = canonicalString.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not render string to bytes");
        }
        Signature sig = null;
        try {
            sig = provider != null ? Signature.getInstance("SHA256withRSA", provider) : Signature.getInstance("SHA256withRSA");
            sig.initSign(privateKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not initialize signature algorithm: " + e, e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Could not initialize signature algorithm: " + e, e);
        }
        try {
            sig.update(bytes);
            byte[] signature = sig.sign();
            return KeyUtils.urlSafeEncodeBase64(signature);
        }
        catch (SignatureException e) {
            throw new RuntimeException("Could not compute metadata signature: " + e);
        }
    }

    public static byte[] extractSubjectKeyIdentifier(byte[] derSki) {
        byte[] dst = new byte[20];
        if (derSki.length != 24) {
            throw new RuntimeException("DER-encoded SKI should be 24 bytes");
        }
        System.arraycopy(derSki, 4, dst, 0, 20);
        return dst;
    }
}

